/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.client.utils.SoundUtils;
import earth.terrarium.adastra.common.blocks.LaunchPadBlock;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.menus.base.PlanetsMenuProvider;
import earth.terrarium.adastra.common.menus.vehicles.RocketMenu;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class Rocket
extends Vehicle {
    private static final RocketProperties TIER_1_PROPERTIES = new RocketProperties(1, (class_1792)ModItems.TIER_1_ROCKET.get(), 1.0f, ModFluidTags.TIER_1_ROCKET_FUEL);
    private static final RocketProperties TIER_2_PROPERTIES = new RocketProperties(2, (class_1792)ModItems.TIER_2_ROCKET.get(), 1.0f, ModFluidTags.TIER_2_ROCKET_FUEL);
    private static final RocketProperties TIER_3_PROPERTIES = new RocketProperties(3, (class_1792)ModItems.TIER_3_ROCKET.get(), 1.0f, ModFluidTags.TIER_3_ROCKET_FUEL);
    private static final RocketProperties TIER_4_PROPERTIES = new RocketProperties(4, (class_1792)ModItems.TIER_4_ROCKET.get(), 1.7f, ModFluidTags.TIER_4_ROCKET_FUEL);
    public static final Map<class_1299<?>, RocketProperties> ROCKET_TO_PROPERTIES = Map.of((class_1299)ModEntityTypes.TIER_1_ROCKET.get(), TIER_1_PROPERTIES, (class_1299)ModEntityTypes.TIER_2_ROCKET.get(), TIER_2_PROPERTIES, (class_1299)ModEntityTypes.TIER_3_ROCKET.get(), TIER_3_PROPERTIES, (class_1299)ModEntityTypes.TIER_4_ROCKET.get(), TIER_4_PROPERTIES);
    public static final int COUNTDOWN_LENGTH = 200;
    public static final class_2940<Boolean> IS_LAUNCHING = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> LAUNCH_TICKS = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> HAS_LAUNCHED = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_IN_VALID_DIMENSION = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Long> FUEL = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_39965);
    public static final class_2940<String> FUEL_TYPE = class_2945.method_12791(Rocket.class, (class_2941)class_2943.field_13326);
    private final SimpleFluidContainer fluidContainer;
    private final RocketProperties properties;
    private boolean launchpadBound;
    private float speed = 0.05f;
    private float angle;
    public boolean startedRocketSound;
    private boolean showFuelMessage = true;

    public Rocket(class_1299<?> type, class_1937 level) {
        this(type, level, ROCKET_TO_PROPERTIES.get(type));
    }

    public Rocket(class_1299<?> type, class_1937 level, RocketProperties properties) {
        super(type, level);
        this.properties = properties;
        this.fluidContainer = new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)3000L), 1, (amount, fluid) -> fluid.is(properties.fuel));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_LAUNCHING, (Object)false);
        this.field_6011.method_12784(LAUNCH_TICKS, (Object)-1);
        this.field_6011.method_12784(HAS_LAUNCHED, (Object)false);
        this.field_6011.method_12784(IS_IN_VALID_DIMENSION, (Object)(AdAstraConfig.launchFromAnywhere || AdAstraData.canLaunchFrom((class_5321<class_1937>)this.method_37908().method_27983()) ? 1 : 0));
        this.field_6011.method_12784(FUEL, (Object)0L);
        this.field_6011.method_12784(FUEL_TYPE, (Object)"air");
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(IS_LAUNCHING, (Object)compound.method_10577("Launching"));
        this.field_6011.method_12778(LAUNCH_TICKS, (Object)compound.method_10550("launchTicks"));
        this.field_6011.method_12778(HAS_LAUNCHED, (Object)compound.method_10577("HasLaunched"));
        this.speed = compound.method_10583("Speed");
        this.angle = compound.method_10583("Angle");
        this.fluidContainer.deserialize(compound);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Launching", this.isLaunching());
        compound.method_10569("LaunchTicks", this.launchTicks());
        compound.method_10556("HasLaunched", this.hasLaunched());
        compound.method_10548("Speed", this.speed);
        compound.method_10548("Angle", this.angle);
        this.fluidContainer.serialize(compound);
    }

    public FluidContainer fluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!this.isLaunching() && !this.hasLaunched()) {
            super.method_5643(source, amount);
        }
        return false;
    }

    @Override
    public class_1799 getDropStack() {
        ItemStackHolder stack = new ItemStackHolder(this.properties.item.method_7854());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return stack.getStack();
        }
        FluidApi.moveFluid((FluidContainer)this.fluidContainer, (FluidContainer)container, (FluidHolder)this.fluidContainer.getFirstFluid(), (boolean)false);
        return stack.getStack();
    }

    public int tier() {
        return this.properties.tier;
    }

    public double method_5621() {
        return this.properties.ridingOffset;
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 location = super.method_24829(passenger).method_1019(passenger.method_5720().method_18805(2.0, 0.0, 2.0).method_1029());
        for (int i = 0; i < 6 && this.method_37908().method_8320(class_2338.method_49638((class_2374)location)).method_26215(); ++i) {
            location = location.method_1023(0.0, 1.0, 0.0);
        }
        return location;
    }

    @Override
    public boolean isSafeToDismount(class_1657 player) {
        return !this.isLaunching() && !this.hasLaunched();
    }

    @Override
    public boolean shouldSit() {
        return false;
    }

    @Override
    public boolean zoomOutCameraInThirdPerson() {
        return true;
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        passenger.method_36456(this.method_36454());
        passenger.method_5847(this.method_5791());
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        passenger.method_36456(passenger.method_36454() + this.angle);
        passenger.method_5847(passenger.method_5791() + this.angle);
    }

    @Override
    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.equals((Object)this.method_5642())) {
            return class_1269.field_5811;
        }
        return super.method_5688(player, hand);
    }

    @Override
    public void method_5773() {
        class_1309 class_13092;
        super.method_5773();
        this.launchPadTick();
        if (this.canLaunch()) {
            this.initiateLaunchSequence();
            this.showFuelMessage = false;
        } else if (this.showFuelMessage && !this.method_37908().method_8608() && this.passengerHasSpaceDown() && (class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            player.method_7353(ConstantComponents.NOT_ENOUGH_FUEL, true);
        }
        if (this.isLaunching()) {
            this.field_6011.method_12778(LAUNCH_TICKS, (Object)(this.launchTicks() - 1));
            if (this.launchTicks() <= 0) {
                this.launch();
            }
            this.spawnSmokeParticles();
        } else if (this.hasLaunched()) {
            this.flightTick();
        }
        if (!this.method_37908().method_8608()) {
            FluidUtils.moveItemToContainer((class_1263)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidUtils.moveContainerToItem((class_1263)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidHolder fluidHolder = this.fluidContainer.getFirstFluid();
            this.field_6011.method_12778(FUEL, (Object)fluidHolder.getFluidAmount());
            this.field_6011.method_12778(FUEL_TYPE, (Object)class_7923.field_41173.method_10221((Object)fluidHolder.getFluid()).toString());
        }
    }

    private void launchPadTick() {
        if (this.method_37908().method_8608() || this.field_6012 % 5 != 0) {
            return;
        }
        if (this.isLaunching() || this.hasLaunched()) {
            return;
        }
        class_2680 state = this.method_37908().method_8320(this.method_24515());
        if (!state.method_28498(LaunchPadBlock.PART)) {
            if (this.launchpadBound) {
                this.drop();
                this.method_43077(class_3417.field_21919);
                this.method_31472();
            }
        } else {
            this.launchpadBound = true;
            if (((Boolean)state.method_11654((class_2769)LaunchPadBlock.POWERED)).booleanValue() && this.hasEnoughFuel()) {
                this.initiateLaunchSequence();
            }
        }
    }

    private void flightTick() {
        if (!this.method_37908().method_8608() && this.method_23318() >= (double)AdAstraConfig.atmosphereLeave) {
            class_1309 class_13092 = this.method_5642();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                if (!(player.field_7512 instanceof PlanetsMenu)) {
                    this.openPlanetsScreen(player);
                }
            } else {
                this.explode();
            }
            return;
        }
        float xxa = -this.xxa();
        this.angle = xxa != 0.0f ? (this.angle += xxa * 1.0f) : (this.angle *= 0.9f);
        if (this.speed < 1.0f) {
            this.speed += 0.005f;
        }
        this.angle = class_3532.method_15363((float)this.angle, (float)-3.0f, (float)3.0f);
        this.method_36456(this.method_36454() + this.angle);
        class_243 delta = this.method_18798();
        this.method_18800(delta.method_10216(), this.speed, delta.method_10215());
        if (this.method_37908().method_8608() && !this.startedRocketSound) {
            this.startedRocketSound = true;
            SoundUtils.playRocketSound(this);
        }
        this.spawnRocketParticles();
        this.burnEntitiesUnderRocket();
        if (this.isObstructed()) {
            this.explode();
        }
    }

    public boolean canLaunch() {
        if (this.isLaunching() || this.hasLaunched()) {
            return false;
        }
        if (!AdAstraConfig.launchFromAnywhere && !((Boolean)this.field_6011.method_12789(IS_IN_VALID_DIMENSION)).booleanValue()) {
            class_1309 class_13092 = this.method_5642();
            if (class_13092 instanceof class_3222) {
                class_3222 player = (class_3222)class_13092;
                player.method_7353(ConstantComponents.INVALID_LAUNCHING_DIMENSION, true);
            }
            this.showFuelMessage = false;
            return false;
        }
        if (!this.hasEnoughFuel()) {
            return false;
        }
        return this.passengerHasSpaceDown();
    }

    public void initiateLaunchSequence() {
        this.field_6011.method_12778(IS_LAUNCHING, (Object)true);
        this.field_6011.method_12778(LAUNCH_TICKS, (Object)200);
        this.method_37908().method_8396(null, this.method_24515(), (class_3414)ModSoundEvents.ROCKET_LAUNCH.get(), class_3419.field_15256, 10.0f, 1.0f);
        this.consumeFuel(false);
    }

    public void launch() {
        this.field_6011.method_12778(HAS_LAUNCHED, (Object)true);
        this.field_6011.method_12778(IS_LAUNCHING, (Object)false);
        this.field_6011.method_12778(LAUNCH_TICKS, (Object)-1);
    }

    public boolean isLaunching() {
        return (Boolean)this.field_6011.method_12789(IS_LAUNCHING);
    }

    public int launchTicks() {
        return (Integer)this.field_6011.method_12789(LAUNCH_TICKS);
    }

    public boolean hasLaunched() {
        return (Boolean)this.field_6011.method_12789(HAS_LAUNCHED);
    }

    public void spawnSmokeParticles() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_17430, this.method_23317(), this.method_23318(), this.method_23321(), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05));
        }
    }

    public void spawnRocketParticles() {
        int i;
        if (!this.method_37908().method_8608()) {
            return;
        }
        for (i = 0; i < 20; ++i) {
            this.method_37908().method_8406((class_2394)ModParticleTypes.LARGE_FLAME.get(), this.method_23317(), this.method_23318() - 0.75, this.method_23321(), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05));
        }
        for (i = 0; i < 5; ++i) {
            this.method_37908().method_8406((class_2394)ModParticleTypes.LARGE_SMOKE.get(), this.method_23317(), this.method_23318() - 0.75, this.method_23321(), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05));
        }
    }

    public void burnEntitiesUnderRocket() {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (class_1309 entity : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(2.0, 30.0, 2.0).method_989(0.0, -37.0, 0.0), e -> true)) {
            if (entity.equals((Object)this.method_5642())) continue;
            entity.method_5639(10);
            entity.method_5643(ModDamageSources.create(this.method_37908(), ModDamageSources.ROCKET_FLAMES), 10.0f);
        }
    }

    public boolean isObstructed() {
        return false;
    }

    public void explode() {
        this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), (float)(7 + this.tier() * 2), OxygenApi.API.hasOxygen(this.method_37908()), class_1937.class_7867.field_40891);
        this.method_31472();
    }

    public boolean consumeFuel(boolean simulate) {
        if (this.method_37908().method_8608()) {
            return false;
        }
        long buckets = FluidConstants.fromMillibuckets((long)(this.fluidContainer.getFirstFluid().is(ModFluidTags.EFFICIENT_FUEL) ? 1000L : 3000L));
        return this.fluidContainer.extractFluid(this.fluidContainer.getFirstFluid().copyWithAmount(buckets), simulate).getFluidAmount() >= buckets;
    }

    public boolean hasEnoughFuel() {
        return this.consumeFuel(true);
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        return new RocketMenu(containerId, inventory, this);
    }

    public FluidHolder fluid() {
        return FluidHolder.of((class_3611)((class_3611)class_7923.field_41173.method_10223(new class_2960((String)this.field_6011.method_12789(FUEL_TYPE)))), (long)((Long)this.field_6011.method_12789(FUEL)));
    }

    public void openPlanetsScreen(class_3222 player) {
        MenuHooks.openMenu((class_3222)player, (ExtraDataMenuProvider)new PlanetsMenuProvider());
        class_2770 packet = new class_2770(class_7923.field_41172.method_10221((Object)((class_3414)ModSoundEvents.ROCKET.get())), class_3419.field_15256);
        player.field_13987.method_14364((class_2596)packet);
    }

    public record RocketProperties(int tier, class_1792 item, float ridingOffset, class_6862<class_3611> fuel) {
    }
}

