/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.audio;

import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import earth.terrarium.adastra.client.radio.audio.RadioSoundInstance;
import earth.terrarium.adastra.client.radio.audio.RadioStream;
import earth.terrarium.adastra.client.radio.audio.StaticRadioSoundInstance;
import earth.terrarium.adastra.client.radio.screen.RadioScreen;
import earth.terrarium.adastra.mixins.client.SoundEngineAccessor;
import earth.terrarium.adastra.mixins.client.SoundManagerAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3521;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public final class RadioHandler {
    private static final Map<String, CompletableFuture<InputStream>> IN_PROGRESS = new ConcurrentHashMap<String, CompletableFuture<InputStream>>();
    private static RadioSoundInstance lastStation = null;

    public static void open(@Nullable class_2338 pos) {
        class_310.method_1551().method_1507((class_437)new RadioScreen(pos));
    }

    public static CompletableFuture<InputStream> getRadioStream(String url) {
        CompletionStage<InputStream> future = IN_PROGRESS.get(url);
        if (future != null && !future.isDone()) {
            return future;
        }
        future = ((CompletableFuture)RadioHandler.streamRadio(url).handle((value, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            return value;
        })).thenApplyAsync(value -> {
            IN_PROGRESS.remove(url);
            return value;
        }, (Executor)class_310.method_1551());
        IN_PROGRESS.put(url, (CompletableFuture<InputStream>)future);
        return future;
    }

    private static CompletableFuture<InputStream> streamRadio(String url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpResponse response = WebUtils.get((String)url, HttpResponse.BodyHandlers.ofInputStream()).orElse(null);
                if (response == null) {
                    throw new IOException("Radio response was null for: " + url);
                }
                if (response.headers().firstValueAsLong("Content-Length").orElse(-1L) >= 0L) {
                    throw new IOException("Radio response had content length for: " + url + " (" + response.headers().firstValueAsLong("Content-Length").orElse(-1L) + ")");
                }
                return new RadioStream((class_7367<InputStream>)((class_7367)response::body));
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        }, (Executor)class_3521.field_15664);
    }

    public static void play(String url, class_5819 random, class_2338 pos) {
        RadioHandler.stopRadioInstances();
        lastStation = new StaticRadioSoundInstance(url, random, pos);
        class_310.method_1551().method_1483().method_4873((class_1113)lastStation);
    }

    public static void play(String url, class_5819 random) {
        RadioHandler.stopRadioInstances();
        lastStation = new RadioSoundInstance(url, random);
        class_310.method_1551().method_1483().method_4873((class_1113)lastStation);
    }

    public static void stop() {
        RadioHandler.stopRadioInstances();
        lastStation = null;
    }

    private static void stopRadioInstances() {
        class_1144 manager = class_310.method_1551().method_1483();
        SoundManagerAccessor accessor = (SoundManagerAccessor)manager;
        class_1140 engine = accessor.getEngine();
        SoundEngineAccessor engineAccessor = (SoundEngineAccessor)engine;
        ArrayList<RadioSoundInstance> radioInstances = new ArrayList<RadioSoundInstance>();
        for (class_1113 soundInstance : engineAccessor.getSoundChannels().keySet()) {
            if (!(soundInstance instanceof RadioSoundInstance)) continue;
            RadioSoundInstance radioInstance = (RadioSoundInstance)soundInstance;
            radioInstances.add(radioInstance);
        }
        radioInstances.forEach(arg_0 -> ((class_1144)manager).method_4870(arg_0));
    }

    public static String getPlaying() {
        if (lastStation == null) {
            return null;
        }
        if (lastStation.method_4793()) {
            return null;
        }
        if (!class_310.method_1551().method_1483().method_4877((class_1113)lastStation)) {
            return null;
        }
        return lastStation.url();
    }

    public static RadioSoundInstance getLastStation() {
        return lastStation;
    }
}

