/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.audio;

import earth.terrarium.adastra.common.utils.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.SampleBuffer;
import net.minecraft.class_4234;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class Mp3AudioStream
extends InputStream
implements class_4234 {
    private final ByteBuffer buffer = ByteBuffer.allocate(4608).order(ByteOrder.LITTLE_ENDIAN);
    private final Decoder decoder = new Decoder();
    private final InputStream input;
    private final Bitstream bitstream;
    private SampleBuffer output;
    private AudioFormat format;

    public Mp3AudioStream(InputStream input) throws IOException {
        this.input = input;
        this.bitstream = new Bitstream(input);
        if (this.readFrame()) {
            throw new IOException("Could not find header.");
        }
    }

    private boolean readFrame() throws IOException {
        this.buffer.clear();
        try {
            Header header = this.bitstream.readFrame();
            if (header == null) {
                return true;
            }
            if (this.output == null) {
                this.output = new SampleBuffer(header.sample_frequency(), header.mode() == 3 ? 1 : 2);
                this.decoder.setOutputBuffer((Obuffer)this.output);
                this.format = new AudioFormat(header.frequency(), 16, this.output.getChannelCount(), true, false);
            }
            if (this.decoder.decodeFrame(header, this.bitstream) != this.output) {
                throw new IllegalStateException("Output buffers are different.");
            }
        }
        catch (ArrayIndexOutOfBoundsException header) {
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        for (short value : this.output.getBuffer()) {
            this.buffer.putShort(value);
        }
        this.buffer.flip();
        this.bitstream.closeFrame();
        return false;
    }

    @Override
    public int read() throws IOException {
        return !this.buffer.hasRemaining() && this.readFrame() ? -1 : this.buffer.get();
    }

    @Override
    public int read(byte @NotNull [] bytes, int offset, int length) throws IOException {
        int count;
        for (count = 0; count < length; count += BufferUtils.read(this.buffer, bytes, offset + count, length, count)) {
            if (this.buffer.hasRemaining() || !this.readFrame()) continue;
            return -1;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.bitstream.close();
        }
        catch (BitstreamException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public AudioFormat method_19719() {
        return this.format;
    }

    @NotNull
    public ByteBuffer method_19720(int size) throws IOException {
        byte[] data = new byte[size];
        int count = IOUtils.read((InputStream)this, (byte[])data);
        ByteBuffer dest = ByteBuffer.allocateDirect(count);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(size != count ? Arrays.copyOf(data, count) : data);
        src.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer destShort = dest.asShortBuffer();
        ShortBuffer srcShort = src.asShortBuffer();
        while (srcShort.hasRemaining()) {
            destShort.put(srcShort.get());
        }
        dest.rewind();
        return dest;
    }
}

