/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.network.IPacket;
import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ClientboundUpdateConfigPacket
implements IPacket<ClientboundUpdateConfigPacket> {
    private final class_2487 configTag;

    public ClientboundUpdateConfigPacket(class_2487 configTag) {
        this.configTag = configTag;
    }

    public static ClientboundUpdateConfigPacket decode(class_2540 buffer) {
        class_2487 configTag = buffer.method_10798();
        return new ClientboundUpdateConfigPacket(configTag);
    }

    @Override
    public void encode(ClientboundUpdateConfigPacket message, class_2540 buffer) {
        buffer.method_10794(message.configTag);
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.UPDATE_CONFIG_ID;
    }

    public static void handle(class_310 client, class_634 listener, class_2540 buf, PacketSender sender) {
        ClientboundUpdateConfigPacket message = ClientboundUpdateConfigPacket.decode(buf);
        client.execute(() -> {
            TravelersBackpack.LOGGER.info("Syncing config from server to client...");
            TravelersBackpackConfigData configData = TravelersBackpackConfig.readFromNbt(message.configTag);
            AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).setConfig((ConfigData)configData);
            BackpackAbilities.ALLOWED_ABILITIES.clear();
            TravelersBackpackConfig.loadItemsFromConfig(TravelersBackpackConfig.getConfig().backpackAbilities.allowedAbilities, BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.getBackpackEffects().clear();
            TravelersBackpackConfig.loadBackpackEffectsFromConfig(configData.backpackAbilities.backpackEffects, BackpackAbilities.BACKPACK_EFFECTS);
            BackpackAbilities.getBackpackEffects().entries().stream().forEach(entry -> {
                if (!BackpackAbilities.ALLOWED_ABILITIES.contains(entry.getKey())) {
                    BackpackAbilities.ALLOWED_ABILITIES.add((class_1792)entry.getKey());
                }
                if (!BackpackAbilities.ITEM_ABILITIES_LIST.contains(entry.getKey())) {
                    BackpackAbilities.ITEM_ABILITIES_LIST.add((class_1792)entry.getKey());
                }
            });
            ArrayList<class_1792> allowed = new ArrayList<class_1792>(BackpackAbilities.ALLOWED_ABILITIES);
            BackpackAbilities.ITEM_ABILITIES_LIST.removeIf(item -> !allowed.contains(item));
            BackpackAbilities.getCooldowns().clear();
            TravelersBackpackConfig.loadCooldownsFromConfig(configData.backpackAbilities.cooldowns, BackpackAbilities.COOLDOWNS);
        });
    }
}

