/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.smelting;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.IMoveSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.AbstractSmeltingWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSmeltingUpgrade<T>
extends UpgradeBase<T>
implements IEnable,
ITickableUpgrade,
IMoveSelector {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private final class_1937 level;
    protected ItemStackHandler items;
    private class_1874 cachedRecipe = null;
    private boolean recipeFetched = false;
    private final class_3956<? extends class_1874> recipeType;
    private final class_1863.class_7266<class_1263, ? extends class_1874> quickCheck;
    private final String upgradeName;

    public AbstractSmeltingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> furnaceContents, class_3956<? extends class_1874> recipeType, String upgradeName) {
        super(manager, dataHolderSlot, new Point(66, 82));
        this.level = manager.getWrapper().getLevel();
        this.items = this.createHandler(furnaceContents);
        this.recipeType = recipeType;
        this.quickCheck = class_1863.method_42302(this.recipeType);
        this.upgradeName = upgradeName;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AbstractSmeltingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + this.upgradeName);
    }

    @Override
    public void onUpgradeRemoved(class_1799 removedStack) {
        NbtHelper.remove(removedStack, "CookingTotalTime");
        NbtHelper.remove(removedStack, "CookingFinishTime");
        NbtHelper.remove(removedStack, "BurnTotalTime");
        NbtHelper.remove(removedStack, "BurnFinishTime");
    }

    @Override
    public List<Pair<Integer, Integer>> getUpgradeSlotsPosition(int x, int y) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        positions.add(Pair.of((Object)(x + 7), (Object)(y + 23)));
        positions.add(Pair.of((Object)(x + 7), (Object)(y + 23 + 36)));
        positions.add(Pair.of((Object)(x + 7 + 18 + 18), (Object)(y + 23 + 18)));
        return positions;
    }

    @Override
    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, this.items, 0, x + 7, y + 23));
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, this.items, 1, x + 7, y + 23 + 36));
        slots.add(new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, this.items, 2, x + 7 + 18 + 18, y + 23 + 18));
        return slots;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.stopCooking();
            this.stopBurning();
        } else {
            this.checkCooking(this.level, false);
        }
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (level.field_9236 || !this.isEnabled(this)) {
            return;
        }
        long currentTime = level.method_8510();
        if (this.isBurning()) {
            if (this.isCooking() && currentTime >= this.getCookingFinishTime()) {
                this.finishCooking();
            }
            if (currentTime >= this.getBurnFinishTime()) {
                this.finishBurning();
            }
        }
        if (player != null && player.field_7512 instanceof BackpackBaseMenu) {
            this.tickSmelting(level);
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    @Override
    public int getTickRate() {
        return 5;
    }

    public boolean isFuel(class_1799 pStack) {
        return this.getBurnDuration(pStack) > 0;
    }

    public boolean isBurning() {
        return this.getBurnFinishTime() > 0L;
    }

    public boolean isCooking() {
        return this.getCookingFinishTime() > 0L;
    }

    public boolean hasFuel() {
        return !this.getStack(1).method_7960() && this.isFuel(this.getStack(1)) || this.isBurning();
    }

    public void tickSmelting(class_1937 level) {
        if (!this.recipeFetched && this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303((class_1263)this.items, level).orElse(null);
            this.recipeFetched = true;
        }
        boolean shouldStop = false;
        if (this.isCooking() && this.isBurning()) {
            if (this.cachedRecipe != null) {
                class_1874 currentRecipe = this.quickCheck.method_42303((class_1263)this.items, level).orElse(null);
                if (this.cachedRecipe != currentRecipe) {
                    this.cachedRecipe = currentRecipe;
                    shouldStop = true;
                }
            } else {
                shouldStop = true;
            }
        }
        if (shouldStop) {
            this.stopCooking();
            this.checkCooking(level, false);
        }
    }

    public void checkCooking(class_1937 level, boolean force) {
        if (level.field_9236 || !this.isEnabled(this)) {
            return;
        }
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303((class_1263)this.items, level).orElse(null);
        }
        if ((force || !this.isCooking()) && this.canBurn(this.cachedRecipe)) {
            if (!this.isBurning()) {
                this.startBurning();
            }
            this.startCooking(this.cachedRecipe);
        }
    }

    public void startCooking(class_1874 recipe) {
        int cookingDuration = recipe.method_8167();
        this.setCookingFinishTime(this.level.method_8510() + (long)cookingDuration);
        this.setCookingTotalTime(cookingDuration);
    }

    public void startBurning() {
        int litDuration = this.getBurnDuration(this.getStack(1));
        this.setBurnFinishTime(this.level.method_8510() + (long)litDuration);
        this.setBurnTotalTime(litDuration);
        this.shrinkFuelSlot();
    }

    private boolean canBurn(@Nullable class_1874 recipe) {
        if (!this.getStack(0).method_7960() && recipe != null && this.hasFuel()) {
            class_1799 cookingResult = recipe.method_8116((class_1263)this.items, this.level.method_30349());
            if (cookingResult.method_7960()) {
                return false;
            }
            class_1799 resultSlotStack = this.getStack(2);
            if (resultSlotStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)resultSlotStack, (class_1799)cookingResult)) {
                return false;
            }
            if (resultSlotStack.method_7947() + cookingResult.method_7947() <= this.items.getSlotLimit(2) && resultSlotStack.method_7947() + cookingResult.method_7947() <= resultSlotStack.method_7914()) {
                return true;
            }
            return resultSlotStack.method_7947() + cookingResult.method_7947() <= cookingResult.method_7914();
        }
        return false;
    }

    public void finishCooking() {
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.method_42303((class_1263)this.items, this.level).orElse(null);
        }
        if (this.cachedRecipe != null) {
            class_1799 result = this.cachedRecipe.method_8116((class_1263)this.items, this.level.method_30349());
            class_1799 input = this.getStack(0).method_7972();
            class_1799 resultSlot = this.getStack(2).method_7972();
            if (!resultSlot.method_7960()) {
                resultSlot.method_7933(1);
            } else {
                resultSlot = result;
            }
            if (input.method_31574(class_2246.field_10562.method_8389()) && !this.getStack(1).method_7960() && this.getStack(1).method_31574(class_1802.field_8550)) {
                this.setStack(1, new class_1799((class_1935)class_1802.field_8705));
            }
            input.method_7934(1);
            this.setStack(0, input);
            this.setStack(2, resultSlot);
        }
        if (this.canBurn(this.cachedRecipe)) {
            this.checkCooking(this.level, true);
        } else {
            this.stopCooking();
        }
    }

    public void shrinkFuelSlot() {
        class_1799 fuel = this.getStack(1).method_7972();
        if (fuel.method_7909().method_7858() != null) {
            this.setStack(1, fuel.method_7909().method_7858().method_7854());
        } else {
            fuel.method_7934(1);
            this.setStack(1, fuel);
        }
    }

    public void finishBurning() {
        class_1799 fuel = this.getStack(1).method_7972();
        if (this.isFuel(fuel) && this.isCooking()) {
            this.startBurning();
        } else {
            this.stopCooking();
            this.stopBurning();
            this.cachedRecipe = null;
        }
    }

    public void setStack(int slot, class_1799 stack) {
        this.items.setStackInSlot(slot, stack);
    }

    public class_1799 getStack(int slot) {
        return this.items.getStackInSlot(slot);
    }

    protected int getBurnDuration(class_1799 pFuel) {
        if (pFuel.method_7960()) {
            return 0;
        }
        return this.getFabricBurnDuration(pFuel);
    }

    protected int getFabricBurnDuration(class_1799 fuel) {
        if (FuelRegistry.INSTANCE.get((class_1935)fuel.method_7909()) != null) {
            return (Integer)FuelRegistry.INSTANCE.get((class_1935)fuel.method_7909());
        }
        return 0;
    }

    public int getBurnTotalTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "BurnTotalTime", 0);
    }

    public long getBurnFinishTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "BurnFinishTime", 0L);
    }

    public int getCookingTotalTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "CookingTotalTime", 0);
    }

    public long getCookingFinishTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "CookingFinishTime", 0L);
    }

    public void setBurnTotalTime(int time) {
        this.setStackData("BurnTotalTime", time);
    }

    public void setBurnFinishTime(long time) {
        this.setStackData("BurnFinishTime", time);
    }

    public void setCookingTotalTime(int time) {
        this.setStackData("CookingTotalTime", time);
    }

    public void setCookingFinishTime(long time) {
        this.setStackData("CookingFinishTime", time);
    }

    public void stopCooking() {
        this.setCookingFinishTime(0L);
        this.setCookingTotalTime(0);
    }

    public void stopBurning() {
        this.setBurnFinishTime(0L);
        this.setBurnTotalTime(0);
    }

    public void setSlotChanged(class_1799 dataHolderStack, int index, class_1799 stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 3, index, stack);
    }

    public void setStackData(String data, Object value) {
        class_1799 stack = this.getDataHolderStack().method_7972();
        if (value == null) {
            NbtHelper.remove(stack, data);
        } else {
            NbtHelper.set(stack, data, value);
        }
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), stack);
    }

    private ItemStackHandler createHandler(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                AbstractSmeltingUpgrade.this.updateDataHolderUnchecked(dataHolderStack -> AbstractSmeltingUpgrade.this.setSlotChanged((class_1799)dataHolderStack, slot, this.getStackInSlot(slot)));
                if (AbstractSmeltingUpgrade.this.getUpgradeManager().getWrapper().getScreenID() == 2) {
                    AbstractSmeltingUpgrade.this.checkCooking(AbstractSmeltingUpgrade.this.level, false);
                }
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                if (slot == 0) {
                    return BackpackSlotItemHandler.isItemValid(stack);
                }
                if (slot == 1) {
                    class_1799 fuel = AbstractSmeltingUpgrade.this.getStack(1);
                    return AbstractSmeltingUpgrade.this.getFabricBurnDuration(stack) > 0 || stack.method_31574(class_1802.field_8550) && !fuel.method_31574(class_1802.field_8550);
                }
                return false;
            }

            @Override
            protected int getStackLimit(int slot, @NotNull class_1799 stack) {
                if (slot == 1 && stack.method_31574(class_1802.field_8550)) {
                    return 1;
                }
                return super.getStackLimit(slot, stack);
            }
        };
    }
}

