/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.CraftingSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeLockableSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_8566;

public class BackpackBaseMenu
extends AbstractBackpackMenu {
    public List<UpgradeLockableSlotItemHandler> upgradeSlot = new ArrayList<UpgradeLockableSlotItemHandler>();
    public Map<Optional<UpgradeBase<?>>, List<Integer>> mappedSlots = new HashMap();
    public int unmodifiableSlotCount = 0;
    public int TOOL_START;
    public int TOOL_END;
    public int UPGRADE_START;
    public int UPGRADE_END;
    public int CRAFTING_RESULT;
    public int CRAFTING_GRID_START;
    public int CRAFTING_GRID_END;

    public BackpackBaseMenu(class_3917<?> type, int windowID, class_1661 inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void addSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.addBackpackStorageSlots(this.wrapper);
        this.BACKPACK_INV_END = this.field_7761.size();
        this.TOOL_START = this.field_7761.size();
        this.addBackpackToolSlots(this.wrapper);
        this.TOOL_END = this.field_7761.size();
        this.UPGRADE_START = this.field_7761.size();
        this.addBackpackUpgradeSlots(this.wrapper);
        this.UPGRADE_END = this.field_7761.size();
        this.PLAYER_INV_START = this.field_7761.size();
        this.addPlayerInventoryAndHotbar(this.inventory, this.wrapper.getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.field_7761.size();
        this.unmodifiableSlotCount = this.field_7761.size();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
    }

    public void rebuildSlots() {
        this.extendedScreenOffset = 0;
        this.field_7764.clear();
        this.field_7761.clear();
        this.field_29206.clear();
        this.addSlots();
    }

    public void addModifiableSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.updateSlotsPosition();
        this.updateBackpackUpgradeSlots();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
    }

    public void rebuildModifiableSlots() {
        this.extendedScreenOffset = 0;
        if (this.field_7764.size() > this.unmodifiableSlotCount) {
            this.field_7764.subList(this.unmodifiableSlotCount, this.field_7764.size()).clear();
        }
        if (this.field_7761.size() > this.unmodifiableSlotCount) {
            this.field_7761.subList(this.unmodifiableSlotCount, this.field_7761.size()).clear();
        }
        if (this.field_29206.size() > this.unmodifiableSlotCount) {
            this.field_29206.subList(this.unmodifiableSlotCount, this.field_29206.size()).clear();
        }
        this.addModifiableSlots();
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.canCraft(this.inventory.field_7546.method_37908(), this.inventory.field_7546));
    }

    public void updateModifiableSlotsPosition(int slot) {
        this.updateBackpackUpgradeSlots();
        this.updateUpgradeSlotsPosition(slot);
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.canCraft(this.inventory.field_7546.method_37908(), this.inventory.field_7546));
    }

    public void updateSlotsPosition() {
        int i;
        int slot = 0;
        for (int i2 = this.BACKPACK_INV_START; i2 < this.BACKPACK_INV_END; ++i2) {
            if (!((class_1735)this.field_7761.get(i2)).getClass().equals(BackpackSlotItemHandler.class)) continue;
            ((class_1735)this.field_7761.get((int)i2)).field_7873 = this.extendedScreenOffset + 8 + slot * 18;
            if (slot < this.getWrapper().getSlotsInRow() - 1) {
                ++slot;
                continue;
            }
            slot = 0;
        }
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (this.getWrapper().isExtended()) {
            modifiedOffset += 36;
        }
        for (i = this.UPGRADE_START; i < this.UPGRADE_END; ++i) {
            if (!((class_1735)this.field_7761.get(i)).getClass().equals(UpgradeLockableSlotItemHandler.class)) continue;
            ((class_1735)this.field_7761.get((int)i)).field_7873 = 162 + modifiedOffset + 15;
        }
        modifiedOffset = this.extendedScreenOffset;
        if (this.getWrapper().isExtended()) {
            modifiedOffset += 18;
        }
        slot = 0;
        for (i = this.PLAYER_INV_START; i < this.PLAYER_HOT_END; ++i) {
            if (!(((class_1735)this.field_7761.get((int)i)).field_7871 instanceof class_1661)) continue;
            ((class_1735)this.field_7761.get((int)i)).field_7873 = modifiedOffset + 8 + slot * 18;
            if (slot < 8) {
                ++slot;
                continue;
            }
            slot = 0;
        }
    }

    public void updateBackpackUpgradeSlots() {
        AtomicInteger nextSlot = new AtomicInteger();
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (int i = this.wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (this.wrapper.getUpgrades().getStackInSlot(i).method_7960()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !this.wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = NbtHelper.getOrDefault(this.wrapper.getUpgrades().getStackInSlot(i), "TabOpen", false);
        }
        boolean finalTabOpened = tabOpened;
        int finalLastOccupiedSlot = lastOccupiedSlot;
        this.field_7761.stream().filter(slot -> slot instanceof UpgradeLockableSlotItemHandler).forEach(slot -> {
            UpgradeLockableSlotItemHandler upgradeSlot = (UpgradeLockableSlotItemHandler)((Object)slot);
            upgradeSlot.setHidden(false);
            int j = slot.method_34266();
            if (j > 0) {
                Optional upgrade = (Optional)this.wrapper.getUpgradeManager().mappedUpgrades.get((Object)(j - 1));
                if (upgrade != null && upgrade.isPresent()) {
                    nextSlot.addAndGet(((IUpgrade)upgrade.get()).getTabSize().y() + 1);
                } else {
                    nextSlot.addAndGet(25);
                }
            }
            upgradeSlot.field_7872 = 33 + nextSlot.get();
            if (finalTabOpened && upgradeSlot.method_34266() > finalLastOccupiedSlot) {
                upgradeSlot.setHidden(true);
            }
            upgradeSlot.setLocked(upgradeSlot.method_7677().method_7909() instanceof UpgradeItem);
        });
    }

    public void updateUpgradeSlotsPosition(int changedSlot) {
        for (Map.Entry entry : this.wrapper.getUpgradeManager().mappedUpgrades.entrySet()) {
            ((Optional)entry.getValue()).ifPresent(upgradeLoaded -> {
                int x = this.upgradeSlot.get((int)((Integer)this.wrapper.getUpgradeManager().mappedUpgrades.inverse().get(entry.getValue())).intValue()).field_7873 - 4;
                int y = this.upgradeSlot.get((int)((Integer)this.wrapper.getUpgradeManager().mappedUpgrades.inverse().get(entry.getValue())).intValue()).field_7872 - 4;
                List<Pair<Integer, Integer>> pos = upgradeLoaded.getUpgradeSlotsPosition(x, y);
                List<Integer> indexes = this.mappedSlots.get(entry.getValue());
                for (int i = 0; i < indexes.size(); ++i) {
                    ((class_1735)this.field_7761.get((int)indexes.get((int)i).intValue())).field_7873 = (Integer)pos.get(i).getFirst();
                    ((class_1735)this.field_7761.get((int)indexes.get((int)i).intValue())).field_7872 = upgradeLoaded.isTabOpened() ? (Integer)pos.get(i).getSecond() : ((class_1735)this.field_7761.get((int)indexes.get((int)i).intValue())).field_7872 - 3000;
                }
                if (upgradeLoaded instanceof CraftingUpgrade) {
                    this.method_7623();
                }
            });
        }
    }

    protected class_1735 method_7621(class_1735 slot) {
        if (slot instanceof UpgradeLockableSlotItemHandler) {
            UpgradeLockableSlotItemHandler upgradeSlotItemHandler = (UpgradeLockableSlotItemHandler)slot;
            this.upgradeSlot.add(upgradeSlotItemHandler);
        }
        return super.method_7621(slot);
    }

    public void addBackpackToolSlots(BackpackWrapper wrapper) {
        for (int i = 0; i < wrapper.getTools().getSlots(); ++i) {
            this.method_7621(new ToolSlotItemHandler(wrapper, i, -14, 18 + i * 18));
        }
    }

    public void addBackpackUpgradeSlots(BackpackWrapper wrapper) {
        int i;
        this.upgradeSlot.clear();
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (this.getWrapper().isExtended()) {
            modifiedOffset += 36;
        }
        int nextSlot = 0;
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (i = wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (wrapper.getUpgrades().getStackInSlot(i).method_7960()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = NbtHelper.getOrDefault(wrapper.getUpgrades().getStackInSlot(i), "TabOpen", false);
        }
        for (i = 0; i < wrapper.getUpgrades().getSlots(); ++i) {
            if (i > 0) {
                Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)(i - 1));
                nextSlot = upgrade != null && upgrade.isPresent() ? (nextSlot += ((IUpgrade)upgrade.get()).getTabSize().y() + 1) : (nextSlot += 25);
            }
            UpgradeLockableSlotItemHandler slot = new UpgradeLockableSlotItemHandler(this, wrapper.getUpgrades(), i, 162 + modifiedOffset + 15, 33 + nextSlot);
            if (tabOpened && slot.method_34266() > lastOccupiedSlot) {
                slot.setHidden(true);
            }
            this.method_7621(slot);
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.getWrapper().isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.getWrapper().getRows() * 18 + 7 + 25 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, modifiedOffset + 8 + x * 18, this.getWrapper().getRows() * 18 + 7 + 83));
        }
    }

    public void addUpgradeListeners() {
        for (Optional upgrade : this.wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(iUpgrade -> iUpgrade.initializeContainers(this, this.wrapper));
        }
    }

    public void addUpgradeSlots(BackpackWrapper wrapper) {
        for (Optional upgrade : wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(upgradeLoaded -> {
                int x = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).field_7873 - 4;
                int y = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).field_7872 - 4;
                List<class_1735> slots = upgradeLoaded.getUpgradeSlots(this, wrapper, x, y);
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (class_1735 slot : slots) {
                    if (!upgradeLoaded.isTabOpened()) {
                        slot.field_7872 -= 2000;
                    }
                    indexes.add(this.field_7761.size());
                    this.method_7621(slot);
                }
                this.mappedSlots.put(upgrade, indexes);
                if (upgradeLoaded instanceof CraftingUpgrade) {
                    this.method_7623();
                }
            });
        }
    }

    protected void method_30010(int pSlotId, int pButton, class_1713 pClickType, class_1657 pPlayer) {
        Object object;
        if (pSlotId >= 0 && pSlotId < this.field_7761.size() && (object = this.field_7761.get(pSlotId)) instanceof TrashSlot) {
            TrashSlot trashSlot = (TrashSlot)((Object)object);
            if (!this.method_34255().method_7960() && trashSlot.method_7681() && pClickType == class_1713.field_7790) {
                trashSlot.method_7673(class_1799.field_8037.method_7972());
            }
        }
        if (pSlotId >= 0 && pSlotId < this.field_7761.size() && (object = this.field_7761.get(pSlotId)) instanceof FilterSlotItemHandler) {
            FilterSlotItemHandler filterSlot = (FilterSlotItemHandler)((Object)object);
            if (this.method_34255().method_7960() && pClickType == class_1713.field_7790 && pButton == 0) {
                super.method_30010(pSlotId, pButton, pClickType, pPlayer);
            } else if (!this.method_34255().method_7960() && filterSlot.method_7680(this.method_34255()) && !filterSlot.method_7681()) {
                filterSlot.method_7673(this.method_34255().method_46651(1));
            }
        } else {
            super.method_30010(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    protected void canCraft(class_1937 level, class_1657 player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.slotChangedCraftingGrid((CraftingUpgrade)craftingUpgrade, level, player));
    }

    public void method_7609(class_1263 container) {
        super.method_7609(container);
        this.canCraft(this.inventory.field_7546.method_37908(), this.inventory.field_7546);
    }

    public void method_34252() {
        super.method_34252();
        this.canCraft(this.inventory.field_7546.method_37908(), this.inventory.field_7546);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent()) {
            return slot.field_7871 != this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get().resultSlots;
        }
        if (slot instanceof FilterSlotItemHandler) {
            return false;
        }
        return super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = this.method_7611(index);
        class_1799 result = class_1799.field_8037;
        if (slot != null && slot.method_7681()) {
            UpgradeSlotItemHandler upgradeSlotItemHandler;
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (slot instanceof ResultSlotExt) {
                ResultSlotExt resultSlotExtNew = (ResultSlotExt)slot;
                return this.handleShiftCraft(this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get(), player, resultSlotExtNew);
            }
            if (slot instanceof CraftingSlot && !this.method_7616(stack, this.BACKPACK_INV_START, this.PLAYER_HOT_END, false)) {
                return class_1799.field_8037;
            }
            if (index >= this.BACKPACK_INV_START && index < this.BACKPACK_INV_END && !this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return class_1799.field_8037;
            }
            if (index >= this.PLAYER_INV_START && index < this.PLAYER_HOT_END) {
                if (this.wrapper.showToolSlots() && ToolSlotItemHandler.isValid(stack) && !this.method_7616(stack, this.TOOL_START, this.TOOL_END, false) && !this.method_7616(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return class_1799.field_8037;
                }
                if (!this.checkMemorySlots(stack) && !this.method_7616(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return class_1799.field_8037;
                }
            }
            if (slot instanceof UpgradeSlotItemHandler && ((upgradeSlotItemHandler = (UpgradeSlotItemHandler)slot).shiftClickToBackpack() ? !this.method_7616(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false) && !this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) : !this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.method_7616(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false))) {
                return class_1799.field_8037;
            }
            if (slot instanceof ToolSlotItemHandler && !this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return class_1799.field_8037;
            }
            if (stack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7673(stack);
            }
            if (stack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stack);
        }
        return result;
    }

    public boolean checkMemorySlots(class_1799 stack) {
        if (!this.wrapper.getMemorySlots().isEmpty()) {
            for (Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : this.wrapper.getMemorySlots()) {
                if (stack.method_7909() != ((class_1799)((Pair)memorizedStack.getSecond()).getFirst()).method_7909() || !((Boolean)((Pair)memorizedStack.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameComponents((class_1799)((Pair)memorizedStack.getSecond()).getFirst(), stack) && this.method_7616(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false) : class_1799.method_7984((class_1799)((class_1799)((Pair)memorizedStack.getSecond()).getFirst()), (class_1799)stack) && this.method_7616(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false))) continue;
                return stack.method_7960();
            }
        }
        return false;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean applyRespectedSlotLogic = startIndex == this.BACKPACK_INV_START && endIndex == this.BACKPACK_INV_END;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(i);
                class_1799 itemstack = slot.method_7677();
                if (!itemstack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemstack)) {
                    int k;
                    int j = itemstack.method_7947() + stack.method_7947();
                    if (j <= (k = slot.method_7676(itemstack))) {
                        stack.method_7939(0);
                        itemstack.method_7939(j);
                        slot.method_7673(itemstack);
                        flag = true;
                    } else if (itemstack.method_7947() < k) {
                        stack.method_7934(k - itemstack.method_7947());
                        itemstack.method_7939(k);
                        slot.method_7673(itemstack);
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.method_7960()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                class_1799 itemstack1;
                class_1735 slot1 = (class_1735)this.field_7761.get(i);
                boolean accept = true;
                Optional<Pair<Integer, Pair<class_1799, Boolean>>> memorizedOptional = this.getWrapper().getMemorizedSlot(slot1.field_7874);
                boolean isUnsortable = this.getWrapper().getUnsortableSlots().contains(slot1.field_7874);
                if (memorizedOptional.isPresent()) {
                    class_1799 memorizedStack = (class_1799)((Pair)memorizedOptional.get().getSecond()).getFirst();
                    boolean matchComponents = (Boolean)((Pair)memorizedOptional.get().getSecond()).getSecond();
                    if (applyRespectedSlotLogic) {
                        boolean bl = accept = matchComponents ? ItemStackUtils.isSameItemSameComponents(memorizedStack, stack) : class_1799.method_7984((class_1799)memorizedStack, (class_1799)stack);
                    }
                }
                if (isUnsortable && !memorizedOptional.isPresent() && accept && applyRespectedSlotLogic) {
                    accept = false;
                }
                if ((itemstack1 = slot1.method_7677()).method_7960() && slot1.method_7680(stack) && accept) {
                    int l = slot1.method_7676(stack);
                    slot1.method_48931(stack.method_7971(Math.min(stack.method_7947(), l)));
                    slot1.method_7668();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public class_1799 handleShiftCraft(CraftingUpgrade upgrade, class_1657 player, ResultSlotExt resultSlot) {
        class_1799 outputCopy = class_1799.field_8037;
        if (resultSlot != null && resultSlot.method_7681()) {
            upgrade.craftSlots.checkChanges = false;
            class_1860 recipe = upgrade.resultSlots.method_7663();
            while (recipe != null && recipe.method_8115((class_1263)upgrade.craftSlots, player.method_37908())) {
                class_1799 recipeOutput = recipe.method_8116((class_1263)upgrade.craftSlots, player.method_37908().method_30349());
                if (recipeOutput.method_7960()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + String.valueOf(recipe) + " - This is NOT a bug in Traveler's Backpack!");
                }
                outputCopy = recipeOutput.method_7972();
                recipeOutput.method_7982(player.method_37908(), player, 1);
                if (!player.method_37908().field_9236) {
                    if (upgrade.shiftClickToBackpack(upgrade.getDataHolderStack())) {
                        if (!this.checkMemorySlots(recipeOutput) && !this.method_7616(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                            upgrade.craftSlots.checkChanges = true;
                            return class_1799.field_8037;
                        }
                    } else if (!this.method_7616(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.method_7616(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                        upgrade.craftSlots.checkChanges = true;
                        return class_1799.field_8037;
                    }
                }
                resultSlot.field_7869 += outputCopy.method_7947();
                resultSlot.method_7667(player, recipeOutput);
            }
            upgrade.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(upgrade, player.method_37908(), player);
        }
        return outputCopy;
    }

    public void slotChangedCraftingGrid(CraftingUpgrade upgrade, class_1937 world, class_1657 player) {
        if (!world.field_9236 && upgrade.craftSlots.checkChanges) {
            class_1860 oldRecipe;
            class_1799 itemstack = class_1799.field_8037;
            class_1860 recipe = oldRecipe = upgrade.resultSlots.method_7663();
            if (TravelersBackpack.polymorphLoaded && PolymorphCompat.shouldResetRecipe((class_1860<class_8566>)recipe, this, upgrade.craftSlots, world, player)) {
                recipe = null;
            }
            if (recipe == null || !recipe.method_8115((class_1263)upgrade.craftSlots, world)) {
                recipe = TravelersBackpack.polymorphLoaded ? PolymorphCompat.getPolymorphedRecipe(this, upgrade.craftSlots, world, player) : (class_1860)world.method_8433().method_8132(class_3956.field_17545, (class_1263)upgrade.craftSlots, world).orElse(null);
            }
            if (recipe != null) {
                itemstack = recipe.method_8116((class_1263)upgrade.craftSlots, world.method_30349());
            }
            if (oldRecipe != recipe || upgrade.resultSlots.method_5438(0).method_7960()) {
                for (class_1657 user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof class_3222).toList()) {
                    PacketDistributorHelper.sendToPlayer((class_3222)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                }
                upgrade.resultSlots.method_5447(0, itemstack);
                upgrade.resultSlots.method_7662(recipe);
            } else if (recipe != null && (recipe.method_8118() || !recipe.getClass().getName().startsWith("net.minecraft") && !class_1799.method_7973((class_1799)itemstack, (class_1799)upgrade.resultSlots.method_5438(0)))) {
                for (class_1657 user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof class_3222).toList()) {
                    PacketDistributorHelper.sendToPlayer((class_3222)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                }
                upgrade.resultSlots.method_5447(0, itemstack);
                upgrade.resultSlots.method_7662(recipe);
            }
        }
    }

    public void method_7595(class_1657 player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> BackpackBaseMenu.checkHandlerAndPlaySound(craftingUpgrade.crafting, player, craftingUpgrade.crafting.getSlots()));
        this.wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> this.clearSlotsAndPlaySound(this.inventory.field_7546, tanksUpgrade.getFluidSlotsHandler(), 4));
        this.wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).ifPresent(this::voidTrashSlot);
        this.shiftTools(this.wrapper.getTools());
        super.method_7595(player);
    }

    public void clearSlotsAndPlaySound(class_1657 player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, handler, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            BackpackBaseMenu.playSound(player);
        }
    }

    public boolean clearSlot(class_1657 player, ItemStackHandler handler, int index) {
        if (!handler.getStackInSlot(index).method_7960()) {
            class_3222 serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.method_5805() || player instanceof class_3222 && (serverPlayer = (class_3222)player).method_14239()) {
                class_1799 stack = handler.getStackInSlot(index).method_7972();
                handler.setStackInSlot(index, class_1799.field_8037);
                player.method_7328(stack, false);
                return false;
            }
            class_1799 stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, class_1799.field_8037);
            player.method_31548().method_7398(stack);
            return true;
        }
        return false;
    }

    public static void playSound(class_1657 player) {
        player.method_37908().method_8396(player, player.method_24515(), class_3417.field_15197, class_3419.field_15245, 1.0f, (1.0f + (player.method_37908().method_8409().method_43057() - player.method_37908().method_8409().method_43057()) * 0.2f) * 0.7f);
    }

    public void shiftTools(ItemStackHandler toolSlotsHandler) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < toolSlotsHandler.getSlots(); ++i) {
            if (foundEmptySlot && !toolSlotsHandler.getStackInSlot(i).method_7960()) {
                needsShifting = true;
            }
            if (!toolSlotsHandler.getStackInSlot(i).method_7960() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            class_2371 tools = class_2371.method_10213((int)toolSlotsHandler.getSlots(), (Object)class_1799.field_8037);
            int j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (toolSlotsHandler.getStackInSlot(i).method_7960()) continue;
                tools.set(j, (Object)toolSlotsHandler.getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (tools.isEmpty()) continue;
                toolSlotsHandler.setStackInSlot(i, (class_1799)tools.get(j));
                ++j;
            }
        }
    }

    public void voidTrashSlot(VoidUpgrade upgrade) {
        upgrade.voidTrashSlotStack();
    }

    public static void checkHandlerAndPlaySound(ItemStackHandler handler, class_1657 player, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = BackpackBaseMenu.clearSlot(handler, player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            BackpackBaseMenu.playSound(player);
        }
    }

    public static boolean clearSlot(ItemStackHandler handler, class_1657 player, int index) {
        if (!BackpackSlotItemHandler.isItemValid(handler.getStackInSlot(index))) {
            if (player == null) {
                return false;
            }
            if (!player.method_5805()) {
                class_3222 serverPlayer;
                class_1799 stack = handler.getStackInSlot(index).method_7972();
                handler.setStackInSlot(index, class_1799.field_8037);
                if (player instanceof class_3222 && !(serverPlayer = (class_3222)player).method_14239()) {
                    player.method_7328(stack, false);
                }
                return false;
            }
            class_1799 stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, class_1799.field_8037);
            player.method_31548().method_7398(stack);
            return true;
        }
        return false;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }
}

