/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.misc;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.util.RenderUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class AdvancementHintRenderer {
    private static final ConcurrentMap<class_2960, Boolean> RENDER_ADVANCEMENT_MAP = new ConcurrentHashMap<class_2960, Boolean>();
    private static final class_2960 TEXTURE = MineCells.createId("textures/misc/hint_marker.png");
    private final class_2960 advancementId;
    private final class_918 itemRenderer;
    private final int color;
    private final class_1792 item;

    public AdvancementHintRenderer(class_2960 advancementId, class_918 itemRenderer, int argb, @Nullable class_1935 item) {
        this.advancementId = advancementId;
        this.itemRenderer = itemRenderer;
        this.color = argb;
        class_1792 class_17922 = this.item = item == null ? null : item.method_8389();
        if (advancementId != null) {
            RENDER_ADVANCEMENT_MAP.putIfAbsent(advancementId, true);
        }
    }

    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, float animationProgress) {
        boolean shouldRender;
        boolean bl = shouldRender = this.advancementId == null || RENDER_ADVANCEMENT_MAP.getOrDefault(this.advancementId, true) != false;
        if (!shouldRender) {
            return;
        }
        matrixStack.method_22903();
        class_4588 vertices = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)TEXTURE));
        float rotationAngle = class_310.method_1551().method_1561().method_24197().getEulerAnglesYXZ((Vector3f)new Vector3f()).y;
        matrixStack.method_22907(new Quaternionf().rotationY(rotationAngle));
        matrixStack.method_46416(-0.0625f, 0.25f, 0.0f);
        double yOffset = (double)Math.sin((float)(animationProgress * 0.33f)) * 0.05;
        matrixStack.method_22904(0.0, yOffset, 0.0);
        RenderUtils.drawBillboard(vertices, matrixStack, 0xF000F0, 1.0f, 1.0f, this.color);
        if (this.item != null) {
            matrixStack.method_22904(0.0625, 0.5 - yOffset * 0.25, 0.0);
            matrixStack.method_22905(0.5f, 0.5f, 0.5f);
            this.itemRenderer.method_23178(this.item.method_7854(), class_811.field_4319, 0xF000F0, -1, matrixStack, vertexConsumerProvider, null, 0);
        }
        matrixStack.method_22909();
    }

    public static void resetAdvancements() {
        RENDER_ADVANCEMENT_MAP.replaceAll((id, b) -> true);
    }

    public static void setAdvancementRendered(class_2960 advancementId, boolean rendered) {
        RENDER_ADVANCEMENT_MAP.replace(advancementId, rendered);
    }
}

