/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.render.MineCellsEntityRenderer;
import com.github.mim1q.minecells.client.render.model.InquisitorEntityModel;
import com.github.mim1q.minecells.entity.InquisitorEntity;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.RenderUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class InquisitorEntityRenderer
extends MineCellsEntityRenderer<InquisitorEntity, InquisitorEntityModel> {
    public static final class_2960 ORB_TEXTURE = MineCells.createId("textures/particle/magic_orb.png");
    public static final class_2960 TEXTURE = MineCells.createId("textures/entity/inquisitor.png");
    public static final class_1921 ORB_LAYER = class_1921.method_23576((class_2960)ORB_TEXTURE);

    public InquisitorEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx, new InquisitorEntityModel(ctx.method_32167(MineCellsRenderers.INQUISITOR_LAYER)), 0.35f);
    }

    @Override
    public void render(InquisitorEntity entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        super.render(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        if (entity.method_5805()) {
            float offset = entity.armUpProgress.getValue() * 0.3f;
            class_4588 vertexConsumer = bufferIn.getBuffer(ORB_LAYER);
            boolean forDisplay = entity.isForDisplay();
            float progress = ((float)entity.field_6012 + partialTicks) * 0.2f;
            this.renderOrb(stack, vertexConsumer, entity.field_6241, progress, new Vector3f(-0.25f, 2.25f, 0.0f), forDisplay);
            this.renderOrb(stack, vertexConsumer, entity.field_6283, progress, new Vector3f(0.6f, 1.0f + offset, 0.4f + offset), forDisplay);
            this.renderOrb(stack, vertexConsumer, entity.field_6283, progress, new Vector3f(0.6f, 1.0f + offset, -0.4f - offset), forDisplay);
        }
    }

    public void renderOrb(class_4587 matrixStack, class_4588 vertexConsumer, float yaw, float age, Vector3f offset, boolean forDisplay) {
        matrixStack.method_22903();
        offset = MathUtils.vectorRotateY(offset, yaw * (float)Math.PI / 180.0f);
        matrixStack.method_22904((double)offset.x(), (double)offset.y() + Math.sin(age) * (double)0.1f, (double)offset.z());
        matrixStack.method_22905(0.375f, 0.375f, 0.375f);
        if (forDisplay) {
            matrixStack.method_22907(new Quaternionf().rotationZ(MathUtils.radians(1.0f)));
            matrixStack.method_22907(new Quaternionf().rotationY(MathUtils.radians(30.0f)));
        } else {
            matrixStack.method_22907(this.field_4676.method_24197());
            matrixStack.method_22907(new Quaternionf().rotationY(MathUtils.radians(180.0f)));
        }
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        RenderUtils.produceVertex(vertexConsumer, matrix4f, matrix3f, 0xF000F0, -0.5f, -0.5f, 0.0f, 0.0f, 1.0f, 255);
        RenderUtils.produceVertex(vertexConsumer, matrix4f, matrix3f, 0xF000F0, 0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 255);
        RenderUtils.produceVertex(vertexConsumer, matrix4f, matrix3f, 0xF000F0, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, 255);
        RenderUtils.produceVertex(vertexConsumer, matrix4f, matrix3f, 0xF000F0, -0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 255);
        matrixStack.method_22909();
    }

    public class_2960 getTexture(InquisitorEntity entity) {
        return TEXTURE;
    }
}

