/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.common;

import com.obscuria.aquamirae.Aquamirae;
import com.obscuria.aquamirae.common.entities.CaptainCorneliaEntity;
import com.obscuria.aquamirae.common.entities.EelEntity;
import com.obscuria.aquamirae.network.ScrollUsePacket;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.obscureapi.api.Icons;
import com.obscuria.obscureapi.api.utils.TextUtils;
import com.obscuria.obscureapi.common.entities.CompoundProjectileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1551;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public final class DelayedEvents {
    private static final List<Event> EVENTS = new ArrayList<Event>();

    public static void register() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            EVENTS.forEach(Event::tick);
            List.copyOf(EVENTS).forEach(event -> {
                ++event.tick;
                if (event.tick > event.length) {
                    EVENTS.remove(event);
                }
            });
        });
    }

    public static void createScrollEvent(class_1657 player) {
        EVENTS.add(new ScrollEvent(player));
    }

    public static void createCorneliaEvent(class_1657 player, class_2338 pos, boolean summon) {
        EVENTS.add(new CorneliaSummonEvent(player, pos, summon));
    }

    static class ScrollEvent
    extends Event {
        private final class_1657 PLAYER;
        private Runnable subEvent = () -> {};

        private ScrollEvent(class_1657 player) {
            super(80, ScrollEvent::onTick);
            this.PLAYER = player;
        }

        @Override
        protected void tick() {
            super.tick();
            this.subEvent.run();
        }

        private static void onTick(Event e) {
            ScrollEvent event = (ScrollEvent)e;
            if (event.tick == 80) {
                ServerPlayNetworking.send((class_3222)((class_3222)event.PLAYER), (FabricPacket)new ScrollUsePacket(event.PLAYER.method_5628()));
                int type = (int)Math.round(7.0 * Math.random());
                switch (type) {
                    default: {
                        event.PLAYER.method_7328(class_1802.field_8477.method_7854(), false);
                        break;
                    }
                    case 1: {
                        event.abyss();
                        break;
                    }
                    case 2: {
                        event.mimic();
                        break;
                    }
                    case 3: {
                        event.moveUp();
                        break;
                    }
                    case 4: {
                        event.moveSide();
                        break;
                    }
                    case 5: {
                        if (event.shelter()) break;
                        event.moveUp();
                        break;
                    }
                    case 6: {
                        event.chakras();
                        break;
                    }
                    case 7: {
                        event.bones();
                    }
                }
            }
        }

        private void abyss() {
            for (int ix = -1; ix <= 1; ++ix) {
                for (int iy = 1; iy >= -10; --iy) {
                    for (int iz = -1; iz <= 1; ++iz) {
                        class_2338 pos = new class_2338(this.PLAYER.method_31477() + ix, this.PLAYER.method_31478() + iy, this.PLAYER.method_31479() + iz);
                        if (!this.PLAYER.method_37908().method_8320(pos).method_26164(Aquamirae.SCROLL_DESTROY)) continue;
                        this.PLAYER.method_37908().method_22352(pos, true);
                    }
                }
            }
        }

        private void mimic() {
            class_1551 drowned = new class_1551(class_1299.field_6123, this.PLAYER.method_37908());
            drowned.method_5943((class_5425)this.PLAYER.method_37908(), this.PLAYER.method_37908().method_8404(this.PLAYER.method_24515()), class_3730.field_16467, null, null);
            drowned.method_33574(this.PLAYER.method_19538());
            drowned.method_5673(class_1304.field_6169, this.PLAYER.method_6118(class_1304.field_6169).method_7972());
            drowned.method_5673(class_1304.field_6174, this.PLAYER.method_6118(class_1304.field_6174).method_7972());
            drowned.method_5673(class_1304.field_6172, this.PLAYER.method_6118(class_1304.field_6172).method_7972());
            drowned.method_5673(class_1304.field_6166, this.PLAYER.method_6118(class_1304.field_6166).method_7972());
            drowned.method_5673(class_1304.field_6173, this.PLAYER.method_6118(class_1304.field_6173).method_7972());
            drowned.method_5673(class_1304.field_6171, this.PLAYER.method_6118(class_1304.field_6171).method_7972());
            drowned.method_5946(class_1304.field_6169, 0.0f);
            drowned.method_5946(class_1304.field_6174, 0.0f);
            drowned.method_5946(class_1304.field_6172, 0.0f);
            drowned.method_5946(class_1304.field_6166, 0.0f);
            drowned.method_5946(class_1304.field_6173, 0.0f);
            drowned.method_5946(class_1304.field_6171, 0.0f);
            this.PLAYER.method_37908().method_8649((class_1297)drowned);
        }

        private boolean shelter() {
            List eels = this.PLAYER.method_37908().method_8390(EelEntity.class, new class_238(this.PLAYER.method_19538(), this.PLAYER.method_19538()).method_1014(128.0), e -> true);
            if (!eels.isEmpty()) {
                this.PLAYER.method_33574(((EelEntity)((Object)eels.get(0))).method_19538());
                return true;
            }
            return false;
        }

        private void chakras() {
            for (float i = 0.0f; i < 1.0f; i += 0.1f) {
                CompoundProjectileEntity.create(AquamiraeEntities.POISONED_CHAKRA, (class_1297)this.PLAYER, (class_1937)this.PLAYER.method_37908(), null, (int)20, (float)i, (int)6000, (int)1);
            }
        }

        private void moveUp() {
            this.length = 140;
            this.subEvent = () -> {
                if (this.tick == 80 || this.tick == 120) {
                    this.PLAYER.method_18799(this.PLAYER.method_18798().method_1031(0.0, 1.5, 0.0));
                    this.PLAYER.field_6037 = true;
                }
                if (this.tick == 100 || this.tick == 140) {
                    this.PLAYER.method_18799(this.PLAYER.method_18798().method_1031(0.0, -1.0, 0.0));
                    this.PLAYER.field_6037 = true;
                }
            };
        }

        private void moveSide() {
            this.length = 100;
            this.subEvent = () -> {
                if (this.tick == 80) {
                    this.PLAYER.method_18799(this.PLAYER.method_18798().method_1031(0.0, 1.5, 0.0));
                    this.PLAYER.field_6037 = true;
                }
                if (this.tick == 100) {
                    this.PLAYER.method_18799(this.PLAYER.method_18798().method_1019(this.PLAYER.method_19538().method_1035(new class_243(this.PLAYER.method_23317() + Math.cos(this.PLAYER.method_36454()) * 3.0, this.PLAYER.method_23318() + 0.5, this.PLAYER.method_23321() + Math.sin(this.PLAYER.method_36454()) * 3.0))));
                    this.PLAYER.field_6037 = true;
                }
            };
        }

        private void bones() {
            this.length = 280;
            this.subEvent = () -> {
                if (this.tick % 20 == 0) {
                    this.PLAYER.method_37908().method_8396(null, this.PLAYER.method_24515(), class_3417.field_19149, class_3419.field_15248, 1.0f, 0.9f + 0.2f * this.PLAYER.method_6051().method_43057());
                    this.PLAYER.method_7344().method_7585(1, 0.0f);
                    this.PLAYER.method_7328(AquamiraeItems.SHARP_BONES.method_7854(), false);
                }
            };
        }
    }

    static class CorneliaSummonEvent
    extends Event {
        private final class_1657 PLAYER;
        private final class_2338 POS;
        private final boolean SUMMON;

        private CorneliaSummonEvent(class_1657 player, class_2338 pos, boolean summon) {
            super(60, CorneliaSummonEvent::onTick);
            this.PLAYER = player;
            this.POS = pos;
            this.SUMMON = summon;
        }

        private static void onTick(Event rawEvent) {
            CorneliaSummonEvent event = (CorneliaSummonEvent)rawEvent;
            if (event.tick == event.length) {
                if (event.SUMMON) {
                    CaptainCorneliaEntity cornelia = new CaptainCorneliaEntity(AquamiraeEntities.CAPTAIN_CORNELIA, event.PLAYER.method_37908());
                    cornelia.method_5641((double)event.POS.method_10263() + 0.5, event.POS.method_10264(), (double)event.POS.method_10260() + 0.5, class_5819.method_43047().method_43057() * 360.0f, 0.0f);
                    cornelia.method_5943((class_5425)event.PLAYER.method_37908(), event.PLAYER.method_37908().method_8404(event.POS), class_3730.field_16471, null, null);
                    event.PLAYER.method_37908().method_8649((class_1297)cornelia);
                    event.PLAYER.method_43496((class_2561)TextUtils.component((String)(Icons.BOSS + class_2561.method_43471((String)"info.captain_spawn").getString())));
                } else {
                    event.PLAYER.method_43496((class_2561)TextUtils.component((String)(Icons.BOSS + class_2561.method_43471((String)"info.captain_spawn_fail").getString())));
                }
            }
        }
    }

    static class Event {
        private final Consumer<Event> ACTION;
        protected int length;
        protected int tick;

        private Event(int length, Consumer<Event> action) {
            this.ACTION = action;
            this.length = length;
        }

        protected void tick() {
            this.ACTION.accept(this);
        }
    }
}

