/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyMinimumInt;
import brentmaas.buildguide.common.property.PropertyNonzeroFloat;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapePolygonalPyramid
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private String[] rotationNames = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
    private static final int[] rotXX = new int[]{1, 0, -1, 0};
    private static final int[] rotXY = new int[]{0, -1, 0, 1};
    private static final int[] rotYX = new int[]{0, 1, 0, -1};
    private PropertyMinimumInt propertySides = new PropertyMinimumInt(4, new AbstractScreenHandler.Translatable("property.buildguide.sides", new Object[0]), () -> this.update(), 3);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, new AbstractScreenHandler.Translatable("property.buildguide.radius", new Object[0]), () -> this.update());
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.Y, new AbstractScreenHandler.Translatable("property.buildguide.direction", new Object[0]), () -> this.update(), this.directionNames);
    private PropertyEnum<rotation> propertyRot = new PropertyEnum<rotation>(rotation.ROT0, new AbstractScreenHandler.Translatable("property.buildguide.rotation", new Object[0]), () -> this.update(), this.rotationNames);
    private PropertyNonzeroFloat propertyHeight = new PropertyNonzeroFloat(4.0f, new AbstractScreenHandler.Translatable("property.buildguide.height", new Object[0]), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.evenmode", new Object[0]), () -> this.update());

    public ShapePolygonalPyramid() {
        this.properties.add(this.propertySides);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRot);
        this.properties.add(this.propertyHeight);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int n = (Integer)this.propertySides.value;
        float radius = ((Float)this.propertyRadius.value).floatValue();
        int rot = ((rotation)((Object)this.propertyRot.value)).ordinal();
        float height = ((Float)this.propertyHeight.value).floatValue();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
            case 0: {
                this.setOriginOffset(0.0, offset, offset);
                break;
            }
            case 1: {
                this.setOriginOffset(offset, 0.0, offset);
                break;
            }
            case 2: {
                this.setOriginOffset(offset, offset, 0.0);
            }
        }
        int h = (int)Math.floor(height > 0.0f ? 0.0 : (double)(height + 1.0f));
        while (true) {
            double d = h;
            double d2 = height > 0.0f ? (double)height : 1.0;
            if (!(d < Math.ceil(d2))) break;
            float r = (radius + 1.0f) * Math.max(Math.abs(height) - (float)Math.abs(h), 0.0f) / Math.abs(height) - 1.0f;
            float rNext = (radius + 1.0f) * Math.max(Math.abs(height) - (float)Math.abs(h) - 1.0f, 0.0f) / Math.abs(height) - 1.0f;
            int maxR = (int)Math.ceil(((double)r + offset) / Math.cos(Math.PI / (double)n));
            for (int a = -maxR; a <= maxR; ++a) {
                block12: for (int b = -maxR; b <= maxR; ++b) {
                    int i;
                    double ri;
                    double theta = Math.atan2((double)b - offset, (double)a - offset) + Math.PI;
                    if (theta < 0.0) {
                        theta += Math.PI * 2;
                    }
                    if (!((ri = ((double)a - offset) * Math.cos((double)(2 * (i = (int)((double)n * theta / 2.0 / Math.PI + 0.5))) * Math.PI / (double)n - Math.PI) + ((double)b - offset) * Math.sin((double)(2 * i) * Math.PI / (double)n - Math.PI) + 1.0E-10) - (double)rNext >= 0.5 && Math.abs(height) <= radius + 1.0f) && (!(ri - (double)r >= -0.5) || !(Math.abs(height) >= radius + 1.0f)) || !(ri - (double)r < 0.5) || !(theta >= (double)(2 * i - 1) * Math.PI / (double)n) || !(theta < (double)(2 * i + 1) * Math.PI / (double)n)) continue;
                    switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
                        case 0: {
                            this.addShapeCube(buffer, h, a * rotXX[rot] + b * rotYX[rot], b * rotXX[rot] + a * rotXY[rot]);
                            continue block12;
                        }
                        case 1: {
                            this.addShapeCube(buffer, a * rotXX[rot] + b * rotYX[rot], h, b * rotXX[rot] + a * rotXY[rot]);
                            continue block12;
                        }
                        case 2: {
                            this.addShapeCube(buffer, b * rotXX[rot] + a * rotXY[rot], a * rotXX[rot] + b * rotYX[rot], h);
                        }
                    }
                }
            }
            ++h;
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.polygonalpyramid";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }

    private static enum rotation {
        ROT0,
        ROT90,
        ROT180,
        ROT270;

    }
}

