/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.State;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.DropdownOverlayScreen;
import brentmaas.buildguide.common.screen.IScreenWrapper;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.ISelectorList;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ISlider;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.screen.widget.IWidget;
import java.util.ArrayList;

public abstract class BaseScreen {
    public static boolean shouldUpdatePersistence = false;
    protected AbstractScreenHandler.Translatable title = new AbstractScreenHandler.Translatable("screen.buildguide.title", new Object[0]);
    protected AbstractScreenHandler.Translatable titleNumberOfBlocksShape = new AbstractScreenHandler.Translatable("screen.buildguide.numberofblocksshape", new Object[0]);
    protected AbstractScreenHandler.Translatable titleNumberOfBlocksTotal = new AbstractScreenHandler.Translatable("screen.buildguide.numberofblockstotal", new Object[0]);
    protected AbstractScreenHandler.Translatable textEnabled = new AbstractScreenHandler.Translatable("screen.buildguide.enable", new Object[0]);
    protected IScreenWrapper wrapper;
    protected ArrayList<Property<?>> properties = new ArrayList();
    private IButton buttonClose;
    private ICheckboxRunnableButton buttonEnabled;
    private IButton buttonBuildGuide;
    private IButton buttonVisualisation;
    private IButton buttonShapeList;
    private IButton buttonConfiguration;

    public BaseScreen() {
        this.buttonBuildGuide = BuildGuide.widgetHandler.createButton(5, 30, 120, 20, new AbstractScreenHandler.Translatable("screen.buildguide.shape", new Object[0]), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Shape)), BuildGuide.stateManager.getState().currentScreen != State.ActiveScreen.Shape);
        this.buttonVisualisation = BuildGuide.widgetHandler.createButton(130, 30, 120, 20, new AbstractScreenHandler.Translatable("screen.buildguide.visualisation", new Object[0]), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Visualisation)), BuildGuide.stateManager.getState().currentScreen != State.ActiveScreen.Visualisation);
        this.buttonShapeList = BuildGuide.widgetHandler.createButton(255, 30, 120, 20, new AbstractScreenHandler.Translatable("screen.buildguide.shapelist", new Object[0]), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Shapelist)), BuildGuide.stateManager.getState().currentScreen != State.ActiveScreen.Shapelist);
        this.buttonConfiguration = BuildGuide.widgetHandler.createButton(380, 30, 120, 20, new AbstractScreenHandler.Translatable("screen.buildguide.configuration", new Object[0]), () -> BuildGuide.screenHandler.showScreen(BuildGuide.stateManager.getState().createNewScreen(State.ActiveScreen.Settings)), BuildGuide.stateManager.getState().currentScreen != State.ActiveScreen.Settings);
    }

    public void init() {
        this.buttonClose = BuildGuide.widgetHandler.createButton(this.wrapper.getWidth() - 25, 5, 20, 20, new AbstractScreenHandler.Translatable("X", new Object[0]), () -> BuildGuide.screenHandler.showScreen(null));
        this.buttonEnabled = BuildGuide.widgetHandler.createCheckbox(5, 5, 20, 20, new AbstractScreenHandler.Translatable("", new Object[0]), BuildGuide.stateManager.getState().enabled, false, () -> {
            BuildGuide.stateManager.getState().enabled = this.buttonEnabled.isCheckboxSelected();
            shouldUpdatePersistence = true;
        });
        this.addWidget(this.buttonEnabled);
        this.addWidget(this.buttonClose);
        this.addWidget(this.buttonBuildGuide);
        this.addWidget(this.buttonVisualisation);
        this.addWidget(this.buttonShapeList);
        this.addWidget(this.buttonConfiguration);
        BuildGuide.stateManager.getState().initCheck();
    }

    public void render() {
        this.drawShadowCentred(this.title.toString(), this.wrapper.getWidth() / 2, 10, 0xFFFFFF);
        this.drawShadowLeft(this.textEnabled.toString(), 30, 10, 0xFFFFFF);
        int titlesMax = Math.max(this.wrapper.getTextWidth(this.titleNumberOfBlocksShape.toString()), this.wrapper.getTextWidth(this.titleNumberOfBlocksTotal.toString()));
        this.drawShadowCentred(this.titleNumberOfBlocksShape.toString(), this.wrapper.getWidth() / 2 - this.wrapper.getTextWidth(this.title.toString()) / 2 - titlesMax / 2 - 20, 5, 0xFFFFFF);
        int n = BuildGuide.stateManager.getState().isShapeAvailable() ? BuildGuide.stateManager.getState().getCurrentShape().getNumberOfBlocks() : 0;
        this.drawShadowCentred(n + " (" + n / 64 + " x 64 + " + n % 64 + ")", this.wrapper.getWidth() / 2 - this.wrapper.getTextWidth(this.title.toString()) / 2 - titlesMax / 2 - 20, 20, 0xFFFFFF);
        this.drawShadowCentred(this.titleNumberOfBlocksTotal.toString(), this.wrapper.getWidth() / 2 + this.wrapper.getTextWidth(this.title.toString()) / 2 + titlesMax / 2 + 20, 5, 0xFFFFFF);
        int nTotal = BuildGuide.stateManager.getState().getNumberOfBlocks();
        this.drawShadowCentred(nTotal + " (" + nTotal / 64 + " x 64 + " + nTotal % 64 + ")", this.wrapper.getWidth() / 2 + this.wrapper.getTextWidth(this.title.toString()) / 2 + titlesMax / 2 + 20, 20, 0xFFFFFF);
        for (Property<?> p : this.properties) {
            p.render(this);
        }
    }

    public void setWrapper(IScreenWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void addWidget(IWidget widget) {
        if (this.wrapper != null) {
            if (widget instanceof IButton) {
                this.wrapper.addButton((IButton)widget);
            } else if (widget instanceof ITextField) {
                this.wrapper.addTextField((ITextField)widget);
            } else if (widget instanceof ICheckboxRunnableButton) {
                this.wrapper.addCheckbox((ICheckboxRunnableButton)widget);
            } else if (widget instanceof ISlider) {
                this.wrapper.addSlider((ISlider)widget);
            } else if (widget instanceof IShapeList) {
                this.wrapper.addShapeList((IShapeList)widget);
            } else if (widget instanceof ISelectorList) {
                this.wrapper.addSelectorList((ISelectorList)widget);
            }
        }
    }

    public void drawShadowLeft(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x, y, colour);
        }
    }

    public void drawShadowCentred(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x - this.wrapper.getTextWidth(text) / 2, y, colour);
        }
    }

    public void drawShadowRight(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x - this.wrapper.getTextWidth(text), y, colour);
        }
    }

    protected void addProperty(Property<?> p) {
        this.properties.add(p);
        p.addToScreen(this);
    }

    protected void addDropdownOverlayScreen(DropdownOverlayScreen dropdown) {
        this.addWidget(dropdown.getOpenButton());
    }

    public void onScreenClosed() {
        if (((Boolean)BuildGuide.config.persistenceEnabled.value).booleanValue() && shouldUpdatePersistence) {
            try {
                BuildGuide.stateManager.savePersistence();
                shouldUpdatePersistence = false;
            }
            catch (Exception e) {
                BuildGuide.logHandler.sendChatMessage("Build Guide persistence failed to save: " + e.getMessage());
                BuildGuide.logHandler.error(e.getMessage() + "\n" + String.valueOf(e.getStackTrace()));
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

