/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.IScreenWrapper;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;

public abstract class AbstractScreenHandler {
    public final String TEXT_MODIFIER_OBFUSCATED = "\u00a7k";
    public final String TEXT_MODIFIER_BOLD = "\u00a7l";
    public final String TEXT_MODIFIER_STRIKETHROUGH = "\u00a7m";
    public final String TEXT_MODIFIER_UNDERLINE = "\u00a7n";
    public final String TEXT_MODIFIER_ITALIC = "\u00a7o";
    public final String TEXT_MODIFIER_RESET = "\u00a7r";
    private static final String[] progressIndicator = new String[]{"|", "/", "-", "\\"};

    public void showScreen(BaseScreen screen) {
        if (screen != null) {
            this.wrapScreen(screen).show();
        } else {
            this.showNone();
        }
    }

    public IScreenWrapper wrapScreen(BaseScreen screen) {
        IScreenWrapper wrapper = this.createWrapper(screen.title);
        wrapper.attachScreen(screen);
        return wrapper;
    }

    public String getFormattedShapeName(ShapeSet shapeSet) {
        Object progressIndicatorPart = "";
        if (shapeSet != null && shapeSet.isShapeAvailable() && !shapeSet.getShape().ready) {
            long time = System.currentTimeMillis();
            progressIndicatorPart = " " + progressIndicator[(int)(time / 100L % (long)progressIndicator.length)];
        }
        return (shapeSet != null && shapeSet.isShapeAvailable() && !shapeSet.visible ? BuildGuide.screenHandler.TEXT_MODIFIER_STRIKETHROUGH : "") + String.valueOf(new Translatable(shapeSet != null && shapeSet.isShapeAvailable() ? shapeSet.getShape().getTranslationKey() : "shape.buildguide.none", new Object[0])) + (String)progressIndicatorPart;
    }

    public int getShapeProgressColour(Shape shape) {
        int colourFraction = (int)Math.max(Math.min((shape != null ? shape.getHowLongAgoCompletedMillis() : 2000L) * 255L / 1000L, 255L), 0L);
        return shape != null && shape.error ? 0xFF0000 : 65280 + colourFraction * 65537;
    }

    public abstract IScreenWrapper createWrapper(Translatable var1);

    public abstract void showNone();

    public abstract String translate(String var1);

    public abstract String translate(String var1, Object ... var2);

    public static class Translatable {
        private String translationKey;
        private Object[] values;

        public Translatable(String translationKey, Object ... values) {
            this.translationKey = translationKey;
            this.values = values;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public Object[] getValues() {
            return this.values;
        }

        public String toString() {
            return BuildGuide.screenHandler.translate(this.translationKey, this.values);
        }
    }
}

