/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;

public abstract class AbstractRenderHandler {
    public abstract void register();

    public abstract void renderShapeBuffer(Shape var1);

    protected abstract void setupRenderingShapeSet(ShapeSet var1);

    protected abstract void endRenderingShapeSet();

    protected abstract void pushProfiler(String var1);

    protected abstract void popProfiler();

    public void render() {
        this.pushProfiler("buildguide");
        if (BuildGuide.stateManager.getState().enabled && BuildGuide.stateManager.getState().isShapeAvailable() && BuildGuide.stateManager.getState().getCurrentShapeSet().origin != null) {
            for (ShapeSet s : BuildGuide.stateManager.getState().shapeSets) {
                this.renderShapeSet(s);
            }
        }
        this.popProfiler();
    }

    protected void renderShapeSet(ShapeSet shapeSet) {
        if (shapeSet.getShape().lock.tryLock()) {
            try {
                if (shapeSet.visible && shapeSet.getShape().ready && !shapeSet.getShape().error && shapeSet.getShape().buffer != null) {
                    if (!shapeSet.getShape().vertexBufferUnpacked) {
                        shapeSet.getShape().buffer.end();
                        shapeSet.getShape().vertexBufferUnpacked = true;
                    }
                    this.setupRenderingShapeSet(shapeSet);
                    this.renderShapeBuffer(shapeSet.getShape());
                    this.endRenderingShapeSet();
                }
            }
            finally {
                shapeSet.getShape().lock.unlock();
            }
        }
    }
}

