/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.indrevemiplugin.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import me.steven.indrev.recipes.machines.IRFluidRecipe;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.entries.InputEntry;
import me.steven.indrev.recipes.machines.entries.OutputEntry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.timardo.indrevemiplugin.IRMachineCategory;
import org.jetbrains.annotations.Nullable;

public class IRMachineRecipe<T extends IRRecipe>
implements EmiRecipe {
    private T recipe;
    private IRMachineCategory<T> category;
    private List<EmiIngredient> inputs;
    private List<EmiStack> outputs;

    public IRMachineRecipe(T recipe, IRMachineCategory<T> category) {
        this.recipe = recipe;
        this.category = category;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.fillInputs();
        this.fillOutputs();
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.recipe.method_8114();
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return this.category.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.category.getDisplayHeight();
    }

    public T getIRRecipe() {
        return this.recipe;
    }

    public void addWidgets(WidgetHolder widgets) {
        this.category.addWidgets(widgets, this);
    }

    private void fillInputs() {
        IRFluidRecipe fluidRecipe;
        ResourceAmount[] fluidInput;
        T t = this.recipe;
        if (t instanceof IRFluidRecipe && (fluidInput = (fluidRecipe = (IRFluidRecipe)t).getFluidInput()).length > 0) {
            this.inputs.add((EmiIngredient)EmiStack.of((class_3611)((FluidVariant)fluidInput[0].resource()).getFluid(), (long)fluidInput[0].amount()));
        }
        for (InputEntry ingredient : this.recipe.getInput()) {
            this.inputs.add(EmiIngredient.of((class_1856)ingredient.getIngredient(), (long)ingredient.getCount()));
        }
    }

    private void fillOutputs() {
        IRFluidRecipe fluidRecipe;
        ResourceAmount[] fluidOutput;
        T t = this.recipe;
        if (t instanceof IRFluidRecipe && (fluidOutput = (fluidRecipe = (IRFluidRecipe)t).getFluidOutput()).length > 0) {
            this.outputs.add(EmiStack.of((class_3611)((FluidVariant)fluidOutput[0].resource()).getFluid(), (long)fluidOutput[0].amount()));
        }
        for (OutputEntry entry : this.recipe.getOutputs()) {
            this.outputs.add(EmiStack.of((class_1799)entry.getStack()));
        }
    }
}

