/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.indrevemiplugin.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.timardo.indrevemiplugin.IndustrialRevolutionEMIPlugin;

public class IREmiPluginConfig {
    private static final File FILE = new File(Path.of(FabricLoader.getInstance().getConfigDir().toString(), "indrev-emi-plugin.json").toString());
    private static final Gson GSON;
    public static final IREmiPluginConfig INSTANCE;
    public boolean addMachineRecipes = true;
    public boolean addMiningRigRecipes = true;
    public boolean addChargedVersions = true;
    public boolean hideNotImplementedItems = true;
    public boolean addMissingItems = true;
    public boolean disableExtraModIntegration = true;

    private IREmiPluginConfig() {
    }

    public IREmiPluginConfig reload() {
        IndustrialRevolutionEMIPlugin.LOGGER.info("Reloading config");
        try {
            if (FILE.createNewFile()) {
                IndustrialRevolutionEMIPlugin.LOGGER.info("No config file found, creating new one");
                IREmiPluginConfig.saveConfig(GSON.toJson((Object)this));
            } else {
                if (GSON.fromJson(new String(Files.readAllBytes(FILE.toPath())), IREmiPluginConfig.class) == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                IndustrialRevolutionEMIPlugin.LOGGER.info("Config successfully reloaded");
            }
        }
        catch (Exception e) {
            IndustrialRevolutionEMIPlugin.LOGGER.error("The config file was empty, loading defaults");
        }
        return this;
    }

    private static void saveConfig(String json) {
        try (PrintWriter printWriter = new PrintWriter(FILE);){
            printWriter.write(json);
            printWriter.flush();
        }
        catch (IOException e) {
            IndustrialRevolutionEMIPlugin.LOGGER.error("The config failed to save ", (Throwable)e);
        }
    }

    static {
        INSTANCE = new IREmiPluginConfig();
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(IREmiPluginConfig.class, type -> INSTANCE).create();
        INSTANCE.reload();
    }
}

