/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.indrevemiplugin;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiStackList;
import java.util.HashSet;
import java.util.Map;
import kotlin.UninitializedPropertyAccessException;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.config.IRConfig;
import me.steven.indrev.config.MiningRigConfig;
import me.steven.indrev.recipes.machines.CompressorRecipe;
import me.steven.indrev.recipes.machines.CondenserRecipe;
import me.steven.indrev.recipes.machines.FluidInfuserRecipe;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.InfuserRecipe;
import me.steven.indrev.recipes.machines.LaserRecipe;
import me.steven.indrev.recipes.machines.ModuleRecipe;
import me.steven.indrev.recipes.machines.PulverizerRecipe;
import me.steven.indrev.recipes.machines.RecyclerRecipe;
import me.steven.indrev.recipes.machines.SawmillRecipe;
import me.steven.indrev.recipes.machines.SmelterRecipe;
import me.steven.indrev.recipes.machines.entries.InputEntry;
import me.steven.indrev.recipes.machines.entries.OutputEntry;
import me.steven.indrev.registry.IRItemRegistry;
import me.steven.indrev.registry.MachineRegistry;
import me.steven.indrev.utils.EnergyutilsKt;
import me.steven.indrev.utils.HiddenitemsKt;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.timardo.indrevemiplugin.IRMachineCategory;
import net.timardo.indrevemiplugin.config.IREmiPluginConfig;
import net.timardo.indrevemiplugin.recipes.IRMachineRecipe;
import net.timardo.indrevemiplugin.recipes.MiningRigRecipeWrapper;
import net.timardo.indrevemiplugin.widget.factory.CompressorWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.CondenserWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.FluidInfuserWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.LaserWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.MiningRigWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.ModularWorkbenchWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.PulverizerWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.RecyclerWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.SawmillWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.SmelterWidgetFactory;
import net.timardo.indrevemiplugin.widget.factory.SolidInfuserWidgetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndustrialRevolutionEMIPlugin
implements ClientModInitializer,
EmiPlugin {
    public static final String MOD_ID = "indrev-emi-plugin";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"indrev-emi-plugin");
    private static final IRMachineCategory<IRRecipe>[] CATEGORIES = new IRMachineCategory[]{new IRMachineCategory<PulverizerRecipe>(PulverizerRecipe.Companion.getTYPE(), MachineRegistry.Companion.getPULVERIZER_REGISTRY(), new PulverizerWidgetFactory(), MachineRegistry.Companion.getPULVERIZER_FACTORY_REGISTRY()), new IRMachineCategory<InfuserRecipe>(InfuserRecipe.Companion.getTYPE(), MachineRegistry.Companion.getSOLID_INFUSER_REGISTRY(), new SolidInfuserWidgetFactory(), MachineRegistry.Companion.getSOLID_INFUSER_FACTORY_REGISTRY()), new IRMachineCategory<CompressorRecipe>(CompressorRecipe.Companion.getTYPE(), MachineRegistry.Companion.getCOMPRESSOR_REGISTRY(), new CompressorWidgetFactory(), MachineRegistry.Companion.getCOMPRESSOR_FACTORY_REGISTRY()), new IRMachineCategory<RecyclerRecipe>(RecyclerRecipe.Companion.getTYPE(), MachineRegistry.Companion.getRECYCLER_REGISTRY(), new RecyclerWidgetFactory()), new IRMachineCategory<FluidInfuserRecipe>(FluidInfuserRecipe.Companion.getTYPE(), MachineRegistry.Companion.getFLUID_INFUSER_REGISTRY(), new FluidInfuserWidgetFactory(), true), new IRMachineCategory<CondenserRecipe>(CondenserRecipe.Companion.getTYPE(), MachineRegistry.Companion.getCONDENSER_REGISTRY(), new CondenserWidgetFactory()), new IRMachineCategory<SmelterRecipe>(SmelterRecipe.Companion.getTYPE(), MachineRegistry.Companion.getSMELTER_REGISTRY(), new SmelterWidgetFactory()), new IRMachineCategory<SawmillRecipe>(SawmillRecipe.Companion.getTYPE(), MachineRegistry.Companion.getSAWMILL_REGISTRY(), new SawmillWidgetFactory()), new IRMachineCategory<ModuleRecipe>(ModuleRecipe.Companion.getTYPE(), MachineRegistry.Companion.getMODULAR_WORKBENCH_REGISTRY(), new ModularWorkbenchWidgetFactory()), new IRMachineCategory<LaserRecipe>(LaserRecipe.Companion.getTYPE(), MachineRegistry.Companion.getLASER_EMITTER_REGISTRY(), new LaserWidgetFactory())};
    private static final IRMachineCategory<MiningRigRecipeWrapper> MINING_RIG_CATEGORY = new IRMachineCategory<MiningRigRecipeWrapper>(MiningRigRecipeWrapper.TYPE_WRAPPER, MachineRegistry.Companion.getMINING_RIG_REGISTRY(), new MiningRigWidgetFactory(), 72, 22);
    private static final class_1792[] CHARGED_ITEMS = new class_1792[]{IRItemRegistry.INSTANCE.getMINING_DRILL_MK1(), IRItemRegistry.INSTANCE.getMINING_DRILL_MK2(), IRItemRegistry.INSTANCE.getMINING_DRILL_MK3(), IRItemRegistry.INSTANCE.getMINING_DRILL_MK4(), IRItemRegistry.INSTANCE.getMODULAR_ARMOR_HELMET(), IRItemRegistry.INSTANCE.getMODULAR_ARMOR_CHEST(), IRItemRegistry.INSTANCE.getMODULAR_ARMOR_LEGGINGS(), IRItemRegistry.INSTANCE.getMODULAR_ARMOR_BOOTS(), IRItemRegistry.INSTANCE.getPORTABLE_CHARGER_ITEM(), IRItemRegistry.INSTANCE.getBATTERY()};

    public void onInitializeClient() {
        LOGGER.info("Let there be recipes! And items.");
    }

    public void register(EmiRegistry registry) {
        IREmiPluginConfig.INSTANCE.reload();
        if (IREmiPluginConfig.INSTANCE.addChargedVersions) {
            for (class_1792 item : CHARGED_ITEMS) {
                this.registerCharged(registry, item);
            }
            this.registerGamerAxe(registry);
        }
        if (IREmiPluginConfig.INSTANCE.hideNotImplementedItems) {
            try {
                registry.removeEmiStacks(IndustrialRevolutionEMIPlugin::removePredicate);
            }
            catch (Exception e) {
                LOGGER.error("An error occured while trying to hide stacks");
                LOGGER.error(e.getMessage());
            }
        }
        if (IREmiPluginConfig.INSTANCE.addMissingItems) {
            try {
                this.registerMissingItems(registry);
            }
            catch (Exception e) {
                LOGGER.error("An error occured while trying to add missing IndRev items");
                LOGGER.error(e.getMessage());
            }
        }
        if (IREmiPluginConfig.INSTANCE.addMachineRecipes) {
            try {
                this.registerCategories(registry);
                this.registerRecipes(registry);
                this.addElectricFurnaceToSmeltingCategory(registry);
            }
            catch (Exception e) {
                LOGGER.error("An error occured while trying to add missing IndRev recipes and categories");
                LOGGER.error(e.getMessage());
            }
        }
        if (IREmiPluginConfig.INSTANCE.addMiningRigRecipes) {
            try {
                this.registerMiningRigRecipes(registry);
            }
            catch (Exception e) {
                LOGGER.error("An exception occured while trying to add mining rig recipes");
                LOGGER.error(e.getMessage());
            }
        }
    }

    private void registerCharged(EmiRegistry registry, class_1792 item) {
        try {
            class_1799 fullEnergy = new class_1799((class_1935)item);
            class_2487 tag = fullEnergy.method_7948();
            tag.method_10544("energy", EnergyutilsKt.energyOf((class_1799)fullEnergy).getCapacity());
            registry.addEmiStackAfter(EmiStack.of((class_1799)fullEnergy), EmiStack.of((class_1935)item));
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while trying to register charged item " + item.toString());
            LOGGER.error(e.getMessage());
        }
    }

    private void registerGamerAxe(EmiRegistry registry) {
        try {
            class_1799 activeGamerAxe = new class_1799((class_1935)IRItemRegistry.INSTANCE.getGAMER_AXE_ITEM());
            class_2487 tag = activeGamerAxe.method_7948();
            tag.method_10544("energy", EnergyutilsKt.energyOf((class_1799)activeGamerAxe).getCapacity());
            tag.method_10556("Active", true);
            tag.method_10548("Progress", 1.0f);
            registry.addEmiStackAfter(EmiStack.of((class_1799)activeGamerAxe), EmiStack.of((class_1935)IRItemRegistry.INSTANCE.getGAMER_AXE_ITEM()));
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while trying to register charged gamer axe");
            LOGGER.error(e.getMessage());
        }
    }

    private static final boolean removePredicate(EmiStack stack) {
        class_2960 id = stack.getId();
        return id == null ? false : HiddenitemsKt.hide((class_2960)id);
    }

    private void registerMissingItems(EmiRegistry registry) {
        long timer = System.currentTimeMillis();
        HashSet registeredStacks = new HashSet(EmiStackList.stacks);
        for (class_1792 entry : class_7923.field_41178) {
            if (!((class_5321)entry.method_40131().method_40230().get()).method_29177().method_12836().equals("indrev") || registeredStacks.contains(EmiStack.of((class_1935)entry))) continue;
            registry.addEmiStack(EmiStack.of((class_1935)entry));
        }
        timer = System.currentTimeMillis() - timer;
        String message = "Adding missing entries took " + timer + "ms";
        if (timer > 2000L) {
            LOGGER.warn(message);
        } else {
            LOGGER.info(message);
        }
    }

    private void registerCategories(EmiRegistry registry) {
        for (IRMachineCategory<IRRecipe> category : CATEGORIES) {
            registry.addCategory(category);
            for (Tier tier : category.getRegistry().getTiers()) {
                registry.addWorkstation(category, (EmiIngredient)EmiStack.of((class_1935)category.getRegistry().block(tier)));
            }
            if (!category.hasFactory()) continue;
            registry.addWorkstation(category, (EmiIngredient)EmiStack.of((class_1935)category.getFactoryRegistry().block(category.getFactoryRegistry().getTiers()[0])));
        }
    }

    private void registerRecipes(EmiRegistry registry) {
        for (IRMachineCategory<IRRecipe> category : CATEGORIES) {
            for (IRRecipe recipe : registry.getRecipeManager().method_30027(category.getType())) {
                registry.addRecipe(new IRMachineRecipe<IRRecipe>(recipe, category));
            }
        }
    }

    private void registerMiningRigRecipes(EmiRegistry registry) {
        MiningRigConfig rigConfig = null;
        try {
            rigConfig = IRConfig.INSTANCE.getMiningRigConfig();
        }
        catch (UninitializedPropertyAccessException e) {
            LOGGER.error("Industrial Revolution config not initialized. Skipping mining rig recipes registration.");
            return;
        }
        registry.addCategory(MINING_RIG_CATEGORY);
        for (Tier tier : MINING_RIG_CATEGORY.getRegistry().getTiers()) {
            registry.addWorkstation(MINING_RIG_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)MINING_RIG_CATEGORY.getRegistry().block(tier)));
        }
        for (Map.Entry entry : rigConfig.getAllowedTags().entrySet()) {
            class_6862 outputTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960((String)entry.getKey()));
            for (class_6880 item : (class_6885.class_6888)class_7923.field_41178.method_40266(outputTag).get()) {
                InputEntry[] inputEntry = new InputEntry[]{};
                OutputEntry[] outputEntry = new OutputEntry[]{new OutputEntry(new class_1799(item), 1.0)};
                MiningRigRecipeWrapper wrappedRecipe = new MiningRigRecipeWrapper(new class_2960(MOD_ID, "/" + ((class_5321)item.method_40230().get()).method_29177().toString().replace(':', '_')), inputEntry, outputEntry, 1000);
                registry.addRecipe(new IRMachineRecipe<MiningRigRecipeWrapper>(wrappedRecipe, MINING_RIG_CATEGORY));
            }
        }
    }

    private void addElectricFurnaceToSmeltingCategory(EmiRegistry registry) {
        MachineRegistry electricFurnace = MachineRegistry.Companion.getELECTRIC_FURNACE_REGISTRY();
        for (Tier tier : electricFurnace.getTiers()) {
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((class_1935)electricFurnace.block(tier)));
        }
        MachineRegistry factory = MachineRegistry.Companion.getELECTRIC_FURNACE_FACTORY_REGISTRY();
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)EmiStack.of((class_1935)factory.block(factory.getTiers()[0])));
    }
}

