/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.indrevemiplugin;

import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import me.steven.indrev.blocks.machine.MachineBlock;
import me.steven.indrev.config.BasicMachineConfig;
import me.steven.indrev.config.HeatMachineConfig;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.IRRecipeType;
import me.steven.indrev.registry.MachineRegistry;
import me.steven.indrev.utils.GuiutilsKt;
import me.steven.indrev.utils.UtilsKt;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.timardo.indrevemiplugin.recipes.IRMachineRecipe;
import net.timardo.indrevemiplugin.widget.EnergyWidget;
import net.timardo.indrevemiplugin.widget.IWidgetFactory;

public class IRMachineCategory<T extends IRRecipe>
extends EmiRecipeCategory {
    private static final class_2960 HEAT_EMPTY = UtilsKt.identifier((String)"textures/gui/widget_temperature_empty.png");
    private static EmiIngredient COOLERS;
    private IRRecipeType<T> type;
    private MachineRegistry registry;
    private MachineRegistry factoryRegistry;
    private IWidgetFactory<T> widgetFactory;
    private boolean isHeatMachine;
    private MachineBlock defaultBlock;
    private int displayWidth = 170;
    private int displayHeight = 75;
    private boolean hasEnergyBar = true;

    public IRMachineCategory(IRRecipeType<T> type, MachineRegistry registry, IWidgetFactory<T> widgetFactory) {
        super(class_2960.method_43902((String)"indrev-emi-plugin", (String)type.getId().method_12832()), (EmiRenderable)EmiStack.of((class_1935)registry.block(registry.getTiers()[0])));
        this.type = type;
        this.registry = registry;
        this.widgetFactory = widgetFactory;
        class_2248 block = registry.block(registry.getTiers()[0]);
        this.defaultBlock = (MachineBlock)block;
        this.isHeatMachine = this.defaultBlock.getConfig() instanceof HeatMachineConfig;
    }

    public IRMachineCategory(IRRecipeType<T> type, MachineRegistry registry, IWidgetFactory<T> widgetFactory, boolean isHeatMachine) {
        this(type, registry, widgetFactory);
        this.isHeatMachine = isHeatMachine;
    }

    public IRMachineCategory(IRRecipeType<T> type, MachineRegistry registry, IWidgetFactory<T> widgetFactory, int customDisplayWidth, int customDisplayHeight) {
        this(type, registry, widgetFactory);
        this.displayWidth = customDisplayWidth;
        this.displayHeight = customDisplayHeight;
        this.hasEnergyBar = false;
    }

    public IRMachineCategory(IRRecipeType<T> type, MachineRegistry registry, IWidgetFactory<T> widgetFactory, MachineRegistry factory) {
        this(type, registry, widgetFactory);
        this.factoryRegistry = factory;
    }

    public IRRecipeType<T> getType() {
        return this.type;
    }

    public MachineRegistry getRegistry() {
        return this.registry;
    }

    public boolean hasFactory() {
        return this.factoryRegistry != null;
    }

    public MachineRegistry getFactoryRegistry() {
        return this.factoryRegistry;
    }

    public void addWidgets(WidgetHolder holder, IRMachineRecipe<T> recipe) {
        this.widgetFactory.addWidgets(holder, recipe);
        if (this.hasEnergyBar) {
            this.addEnergyWidget(holder, recipe.getIRRecipe().getTicks(), recipe);
        }
        if (this.isHeatMachine) {
            this.addTemperatureWidget(holder);
        }
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    private void addEnergyWidget(WidgetHolder holder, int baseTime, IRMachineRecipe<T> recipe) {
        if (this.registry.equals(MachineRegistry.Companion.getLASER_EMITTER_REGISTRY())) {
            holder.add((Widget)new EnergyWidget(IWidgetFactory.loc(0.1), IWidgetFactory.loc(0.15), recipe.getIRRecipe().getTicks(), this.defaultBlock.getConfig().getMaxEnergyStored()));
        } else {
            holder.add((Widget)new EnergyWidget(IWidgetFactory.loc(0.1), IWidgetFactory.loc(0.15), (long)baseTime * ((BasicMachineConfig)this.defaultBlock.getConfig()).getEnergyCost(), this.defaultBlock.getConfig().getMaxEnergyStored()));
        }
    }

    private void addTemperatureWidget(WidgetHolder holder) {
        if (COOLERS == null) {
            COOLERS = EmiIngredient.of((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)UtilsKt.identifier((String)"coolers")));
        }
        holder.addTexture(HEAT_EMPTY, IWidgetFactory.loc(0.95), IWidgetFactory.loc(0.15), 10, 43, 0, 0, 10, 43, 10, 43);
        holder.add((Widget)new SlotWidget(COOLERS, IWidgetFactory.loc(0.75), IWidgetFactory.loc(2.75)){

            public void drawSlotHighlight(class_332 draw, Bounds bounds) {
                EmiDrawContext.wrap((class_332)draw).drawTexture(GuiutilsKt.getVENT_ICON_ID(), IWidgetFactory.loc(0.75), IWidgetFactory.loc(2.75), 18, 18, 0.0f, 0.0f, 18, 18, 18, 18);
                super.drawSlotHighlight(draw, bounds);
            }
        });
        holder.addTexture(GuiutilsKt.getVENT_ICON_ID(), IWidgetFactory.loc(0.75), IWidgetFactory.loc(2.75), 18, 18, 0, 0, 18, 18, 18, 18);
    }
}

