/*
 * Decompiled with CFR 0.152.
 */
package fuzs.nightconfigfixes.mixin;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.io.WritingException;
import fuzs.nightconfigfixes.NightConfigFixes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(targets={"com.electronwill.nightconfig.core.io.ConfigParser"})
interface ConfigParserFabricMixin<C extends Config> {
    @Shadow(remap=false)
    public ConfigFormat<C> getFormat();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite(remap=false)
    default public C parse(Path file, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file, new LinkOption[0]) && !nefAction.run(file, this.getFormat())) {
                return (C)this.getFormat().createConfig();
            }
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                C c = this.parse(input, charset);
                return c;
            }
            catch (ParsingException e) {
                try {
                    C config;
                    Files.delete(file);
                    if (!nefAction.run(file, this.getFormat())) throw e;
                    try (InputStream input2 = Files.newInputStream(file, new OpenOption[0]);){
                        config = this.parse(input2, charset);
                    }
                    NightConfigFixes.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)file.toAbsolutePath());
                    return config;
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occurred", (Throwable)e);
        }
    }

    @Shadow(remap=false)
    public C parse(InputStream var1, Charset var2);

    @Overwrite(remap=false)
    default public void parse(Path file, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file, new LinkOption[0]) && !nefAction.run(file, this.getFormat())) {
                return;
            }
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                this.parse(input, destination, parsingMode, charset);
            }
            catch (ParsingException e) {
                block20: {
                    try {
                        Files.delete(file);
                        if (!nefAction.run(file, this.getFormat())) break block20;
                        try (InputStream input2 = Files.newInputStream(file, new OpenOption[0]);){
                            this.parse(input2, destination, parsingMode, charset);
                        }
                        NightConfigFixes.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)file.toAbsolutePath());
                        return;
                    }
                    catch (Throwable t) {
                        e.addSuppressed(t);
                    }
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occurred", (Throwable)e);
        }
    }

    @Shadow(remap=false)
    public void parse(InputStream var1, Config var2, ParsingMode var3, Charset var4);
}

