/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.client.sound.SpeakerSound;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.peripheral.speaker.EncodedAudio;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4224;

@Environment(value=EnvType.CLIENT)
public class SpeakerInstance {
    public static final class_2960 DFPWM_STREAM = new class_2960("computercraft", "speaker.dfpwm_fake_audio_should_not_be_played");
    @Nullable
    private DfpwmStream currentStream;
    @Nullable
    private SpeakerSound sound;

    SpeakerInstance() {
    }

    private void pushAudio(EncodedAudio buffer) {
        SpeakerSound sound = this.sound;
        DfpwmStream stream = this.currentStream;
        if (stream == null) {
            stream = this.currentStream = new DfpwmStream();
        }
        boolean exhausted = stream.isEmpty();
        stream.push(buffer);
        if (exhausted && sound != null && sound.stream == stream && stream.channel != null && stream.executor != null) {
            DfpwmStream actualStream = sound.stream;
            stream.executor.execute(() -> {
                class_4224 channel = Nullability.assertNonNull(actualStream.channel);
                if (!channel.method_19656()) {
                    channel.method_19640(1);
                }
            });
        }
    }

    public void playAudio(SpeakerPosition position, float volume, EncodedAudio buffer) {
        this.pushAudio(buffer);
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (this.sound != null && this.sound.stream != this.currentStream) {
            soundManager.method_4870((class_1113)this.sound);
            this.sound = null;
        }
        if (this.sound != null && !soundManager.method_4877((class_1113)this.sound)) {
            this.sound = null;
        }
        if (this.sound == null && this.currentStream != null) {
            this.sound = new SpeakerSound(DFPWM_STREAM, this.currentStream, position, volume, 1.0f);
            soundManager.method_4873((class_1113)this.sound);
        }
    }

    public void playSound(SpeakerPosition position, class_2960 location, float volume, float pitch) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        this.currentStream = null;
        if (this.sound != null) {
            soundManager.method_4870((class_1113)this.sound);
            this.sound = null;
        }
        this.sound = new SpeakerSound(location, null, position, volume, pitch);
        soundManager.method_4873((class_1113)this.sound);
    }

    void setPosition(SpeakerPosition position) {
        if (this.sound != null) {
            this.sound.setPosition(position);
        }
    }

    void stop() {
        if (this.sound != null) {
            class_310.method_1551().method_1483().method_4870((class_1113)this.sound);
        }
        this.currentStream = null;
        this.sound = null;
    }
}

