/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_4075;

@Environment(value=EnvType.CLIENT)
public final class GuiSprites
extends class_4075 {
    public static final class_2960 SPRITE_SHEET = new class_2960("computercraft", "gui");
    public static final class_2960 TEXTURE = SPRITE_SHEET.method_45134(x -> "textures/atlas/" + x + ".png");
    public static final ButtonTextures TURNED_OFF = GuiSprites.button("turned_off");
    public static final ButtonTextures TURNED_ON = GuiSprites.button("turned_on");
    public static final ButtonTextures TERMINATE = GuiSprites.button("terminate");
    public static final ComputerTextures COMPUTER_NORMAL = GuiSprites.computer("normal", true, true);
    public static final ComputerTextures COMPUTER_ADVANCED = GuiSprites.computer("advanced", true, true);
    public static final ComputerTextures COMPUTER_COMMAND = GuiSprites.computer("command", false, true);
    public static final ComputerTextures COMPUTER_COLOUR = GuiSprites.computer("colour", true, false);
    @Nullable
    private static GuiSprites instance;

    private static ButtonTextures button(String name) {
        return new ButtonTextures(new class_2960("computercraft", "gui/buttons/" + name), new class_2960("computercraft", "gui/buttons/" + name + "_hover"));
    }

    private static ComputerTextures computer(String name, boolean pocket, boolean sidebar) {
        return new ComputerTextures(new class_2960("computercraft", "gui/border_" + name), pocket ? new class_2960("computercraft", "gui/pocket_bottom_" + name) : null, sidebar ? new class_2960("computercraft", "gui/sidebar_" + name) : null);
    }

    private GuiSprites(class_1060 textureManager) {
        super(textureManager, TEXTURE, SPRITE_SHEET);
    }

    public static GuiSprites initialise(class_1060 textureManager) {
        if (instance != null) {
            throw new IllegalStateException("GuiSprites has already been initialised");
        }
        instance = new GuiSprites(textureManager);
        return instance;
    }

    public static class_1058 get(class_2960 texture) {
        if (instance == null) {
            throw new IllegalStateException("GuiSprites has not been initialised");
        }
        return instance.method_18667(texture);
    }

    public static ComputerTextures getComputerTextures(ComputerFamily family) {
        return switch (family) {
            default -> throw new IncompatibleClassChangeError();
            case ComputerFamily.NORMAL -> COMPUTER_NORMAL;
            case ComputerFamily.ADVANCED -> COMPUTER_ADVANCED;
            case ComputerFamily.COMMAND -> COMPUTER_COMMAND;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public record ButtonTextures(class_2960 normal, class_2960 active) {
        public class_1058 get(boolean active) {
            return GuiSprites.get(active ? this.active : this.normal);
        }

        public Stream<class_2960> textures() {
            return Stream.of(this.normal, this.active);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ComputerTextures(class_2960 border, @Nullable class_2960 pocketBottom, @Nullable class_2960 sidebar) {
        public Stream<class_2960> textures() {
            return Stream.of(this.border, this.pocketBottom, this.sidebar).filter(Objects::nonNull);
        }
    }
}

