/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class CarpetStairBlock
extends ModStairBlock
implements class_2343,
IRecolorable,
IRotatable {
    public static final class_2758 LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;
    public static final class_2746 SOLID = ModBlockProperties.SOLID;
    protected static final class_265 BOTTOM_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final class_265 OCTET_NPN = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)9.0, (double)17.0, (double)9.0);
    protected static final class_265 OCTET_NPP = class_2248.method_9541((double)0.0, (double)8.0, (double)7.0, (double)9.0, (double)17.0, (double)16.0);
    protected static final class_265 OCTET_PPN = class_2248.method_9541((double)7.0, (double)8.0, (double)0.0, (double)16.0, (double)17.0, (double)9.0);
    protected static final class_265 OCTET_PPP = class_2248.method_9541((double)7.0, (double)8.0, (double)7.0, (double)16.0, (double)17.0, (double)16.0);
    protected static final class_265[] BOTTOM_SHAPES = CarpetStairBlock.makeShapes();
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public CarpetStairBlock(class_2248 block) {
        super(() -> block, class_4970.class_2251.method_9630((class_4970)block).method_9631(state -> Math.max(0, (Integer)state.method_11654((class_2769)LIGHT_LEVEL))));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)SOLID, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    private static class_265[] makeShapes() {
        return (class_265[])IntStream.range(0, 16).mapToObj(CarpetStairBlock::makeStairShape).toArray(class_265[]::new);
    }

    private static class_265 makeStairShape(int bitfield) {
        class_2350 dir = switch (bitfield % 4) {
            default -> class_2350.field_11043;
            case 1 -> class_2350.field_11034;
            case 2 -> class_2350.field_11039;
            case 3 -> class_2350.field_11035;
        };
        class_265 voxelShape = MthUtils.rotateVoxelShape((class_265)BOTTOM_AABB, (class_2350)dir);
        if ((bitfield & 1) != 0) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)OCTET_NPN);
        }
        if ((bitfield & 2) != 0) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)OCTET_PPN);
        }
        if ((bitfield & 4) != 0) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)OCTET_NPP);
        }
        if ((bitfield & 8) != 0) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)OCTET_PPP);
        }
        return voxelShape;
    }

    public boolean method_10311(class_1936 level, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            class_2586 class_25862;
            if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te = (CarpetedBlockTile)class_25862;
                if (level instanceof class_1937) {
                    class_1937 l = (class_1937)level;
                    class_2248.method_9577((class_1937)l, (class_2338)pos, (class_1799)te.getCarpet().method_26204().method_8389().method_7854());
                    level.method_8652(pos, (class_2680)te.getHeldBlock().method_26204().method_34725(state).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
                    level.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)level));
                }
            }
            return true;
        }
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654((class_2769)field_11572) == class_2760.field_12617) {
            return BOTTOM_SHAPES[SHAPE_BY_STATE[CarpetStairBlock.getShapeIndex(state)]];
        }
        return super.method_9530(state, level, pos, context);
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)SOLID) != false ? super.method_9571(state, level, pos) : class_259.method_1073();
    }

    private static int getShapeIndex(class_2680 state) {
        return ((class_2778)state.method_11654((class_2769)field_11565)).ordinal() * 4 + ((class_2350)state.method_11654((class_2769)field_11571)).method_10161();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIGHT_LEVEL, SOLID});
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 worldIn, class_2338 pos) {
        IBlockHolder tile;
        class_2680 mimicState;
        class_2586 class_25862 = worldIn.method_8321(pos);
        if (class_25862 instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)class_25862).getHeldBlock()).method_26215() && !(mimicState.method_26204() instanceof CarpetStairBlock)) {
            return mimicState.method_26165(player, worldIn, pos);
        }
        return super.method_9594(state, player, worldIn, pos);
    }

    public class_2498 getSoundType(class_2680 state, class_4538 world, class_2338 pos, class_1297 entity) {
        CarpetedBlockTile tile;
        class_2498 mixed;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CarpetedBlockTile && (mixed = (tile = (CarpetedBlockTile)class_25862).getSoundType()) != null) {
            return mixed;
        }
        return super.method_9573(state);
    }

    public void method_9585(class_1936 level, class_2338 pos, class_2680 state) {
        super.method_9585(level, pos, state);
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        IBlockHolder tile;
        class_2680 mimicState;
        super.method_33614(level, player, pos, state);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)class_25862).getHeldBlock(1)).method_26215()) {
            class_2498 sound = mimicState.method_26231();
            level.method_8396(null, pos, sound.method_10595(), class_3419.field_15245, (sound.method_10597() + 1.0f) / 2.0f, this.field_23162.method_10599() * 0.8f);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        Object object = builder.method_51876(class_181.field_1228);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            class_2680 heldState = tile.getHeldBlock(0);
            class_2680 carpet = tile.getHeldBlock(1);
            Object object2 = builder.method_51876(class_181.field_1226);
            if (object2 instanceof class_3222) {
                class_3222 player = (class_3222)object2;
                if (ForgeHelper.canHarvestBlock((class_2680)heldState, (class_3218)builder.method_51870(), (class_2338)class_2338.method_49638((class_2374)((class_2374)builder.method_51873(class_181.field_24424))), (class_3222)player)) {
                    drops.addAll(heldState.method_26189(builder));
                }
            }
            drops.addAll(carpet.method_26189(builder));
        }
        return drops;
    }

    public class_1799 getCloneItemStack(class_2680 state, class_239 target, class_1922 level, class_2338 pos, class_1657 player) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CarpetedBlockTile) {
            class_3965 hs;
            CarpetedBlockTile tile = (CarpetedBlockTile)class_25862;
            if (target instanceof class_3965 && (hs = (class_3965)target).method_17780() == class_2350.field_11036) {
                return tile.getHeldBlock(1).method_26204().method_9574(level, pos, state);
            }
            class_2680 mimic = tile.getHeldBlock();
            return mimic.method_26204().method_9574(level, pos, state);
        }
        return super.method_9574(level, pos, state);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)class_25862;
            class_2680 mimic = tile.getHeldBlock();
            return mimic.method_26204().method_9574(level, pos, state);
        }
        return super.method_9574(level, pos, state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new CarpetedBlockTile(pPos, pState);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 facingPos) {
        class_2680 newState = super.method_9559(state, facing, facingState, world, currentPos, facingPos);
        class_2586 class_25862 = world.method_8321(currentPos);
        if (class_25862 instanceof CarpetedBlockTile) {
            class_2586 class_25863;
            CarpetedBlockTile tile = (CarpetedBlockTile)class_25862;
            class_2680 oldHeld = tile.getHeldBlock();
            CarpetedBlockTile otherTile = null;
            if (facingState.method_27852(ModRegistry.CARPET_STAIRS.get()) && (class_25863 = world.method_8321(facingPos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te2;
                otherTile = te2 = (CarpetedBlockTile)class_25863;
                facingState = otherTile.getHeldBlock();
            }
            class_2680 newHeld = oldHeld.method_26191(facing, facingState, world, currentPos, facingPos);
            class_2680 newFacing = facingState.method_26191(facing.method_10153(), newHeld, world, facingPos, currentPos);
            if (newFacing != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.method_5431();
                } else {
                    world.method_8652(facingPos, newFacing, 2);
                }
            }
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
            }
        }
        return newState;
    }

    public boolean tryRecolor(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1767 dyeColor) {
        class_2248 otherCarpet;
        CarpetedBlockTile tile;
        class_2680 c;
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof CarpetedBlockTile && !(c = (tile = (CarpetedBlockTile)class_25862).getHeldBlock()).method_26215() && (otherCarpet = BlocksColorAPI.changeColor((class_2248)c.method_26204(), (class_1767)dyeColor)) != null && !c.method_27852(otherCarpet)) {
            tile.setHeldBlock(otherCarpet.method_34725(c));
            tile.method_5431();
            return true;
        }
        return false;
    }

    public boolean isDefaultColor(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)class_25862;
            class_2680 c = tile.getHeldBlock();
            return BlocksColorAPI.isDefaultColor((class_2248)c.method_26204());
        }
        return false;
    }

    public Optional<class_2680> getRotatedState(class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, class_2470 rotation, class_2350 direction, @Nullable class_243 vec3) {
        return direction.method_10166().method_10178() ? Optional.of(this.method_9598(blockState, rotation)) : Optional.empty();
    }

    public void onRotated(class_2680 newState, class_2680 oldState, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)class_25862;
            class_2680 held = tile.getHeldBlock();
            class_2680 newHeld = held.method_26186(rotation);
            tile.setHeldBlock(newHeld);
            tile.method_5431();
        }
    }
}

