/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4663;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;
import techreborn.world.RubberTreeSpikeDecorator;
import techreborn.world.TROreFeatureConfig;

public class WorldGenerator {
    public static final List<TROreFeatureConfig> ORE_FEATURES = WorldGenerator.getOreFeatures();
    public static final class_2960 OIL_LAKE_ID = new class_2960("techreborn", "oil_lake");
    public static final class_5321<class_2975<?, ?>> OIL_LAKE_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)OIL_LAKE_ID);
    public static final class_5321<class_6796> OIL_LAKE_PLACED_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)OIL_LAKE_ID);
    public static final class_2960 RUBBER_TREE_ID = new class_2960("techreborn", "rubber_tree");
    public static final class_5321<class_2975<?, ?>> RUBBER_TREE_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)RUBBER_TREE_ID);
    public static final class_5321<class_6796> RUBBER_TREE_PLACED_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)RUBBER_TREE_ID);
    public static final class_2960 RUBBER_TREE_PATCH_ID = new class_2960("techreborn", "rubber_tree_patch");
    public static final class_5321<class_2975<?, ?>> RUBBER_TREE_PATCH_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)RUBBER_TREE_PATCH_ID);
    public static final class_5321<class_6796> RUBBER_TREE_PATCH_PLACED_FEATURE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)RUBBER_TREE_PATCH_ID);
    public static final class_4663<RubberTreeSpikeDecorator> RUBBER_TREE_SPIKE = (class_4663)class_2378.method_10230((class_2378)class_7923.field_41153, (class_2960)new class_2960("techreborn", "rubber_tree_spike"), (Object)new class_4663(RubberTreeSpikeDecorator.CODEC));

    public static void initWorldGen() {
        if (!(TechRebornConfig.enableOreGeneration || TechRebornConfig.enableRubberTreeGeneration || TechRebornConfig.enableOilLakeGeneration)) {
            return;
        }
        BiomeModifications.create((class_2960)new class_2960("techreborn", "features")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), WorldGenerator.oreModifier()).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag((class_6862)class_6908.field_36517).or(BiomeSelectors.tag((class_6862)class_6908.field_36515)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9471})), WorldGenerator.rubberTreeModifier()).add(ModificationPhase.ADDITIONS, BiomeSelectors.tag((class_6862)class_6908.field_37393), WorldGenerator.oilLakeModifier());
    }

    private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> oreModifier() {
        return (biomeSelectionContext, biomeModificationContext) -> {
            if (!TechRebornConfig.enableOreGeneration) {
                return;
            }
            for (TROreFeatureConfig feature : ORE_FEATURES) {
                if (!feature.biomeSelector().test((BiomeSelectionContext)biomeSelectionContext)) continue;
                biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, feature.placedFeature());
            }
        };
    }

    private static List<TROreFeatureConfig> getOreFeatures() {
        return Arrays.stream(TRContent.Ores.values()).filter(ores -> ores.distribution != null).filter(ores -> ores.distribution.isGenerating()).map(TROreFeatureConfig::of).toList();
    }

    private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> rubberTreeModifier() {
        if (!TechRebornConfig.enableRubberTreeGeneration) {
            return (biomeSelectionContext, biomeModificationContext) -> {};
        }
        return (biomeSelectionContext, biomeModificationContext) -> biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, RUBBER_TREE_PATCH_PLACED_FEATURE);
    }

    private static Consumer<BiomeModificationContext> oilLakeModifier() {
        if (!TechRebornConfig.enableOilLakeGeneration) {
            return biomeModificationContext -> {};
        }
        return biomeModificationContext -> biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_25186, OIL_LAKE_PLACED_FEATURE);
    }
}

