/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.config.TechRebornConfig;
import techreborn.items.armor.AttributeModifierBuilder;
import techreborn.items.armor.TREnergyArmourItem;

public class NanoSuitItem
extends TREnergyArmourItem
implements ArmorBlockEntityTicker,
ArmorRemoveHandler {
    private static final Multimap<class_1320, class_1322> FULL_SUIT = new AttributeModifierBuilder().armor(10).toughness(4).build();
    private final Multimap<class_1320, class_1322> noPowerAttributes;
    private final Multimap<class_1320, class_1322> hasPowerAttributes;
    private final Multimap<class_1320, class_1322> fullSuitAttributes;

    public NanoSuitItem(class_1741 material, class_1738.class_8051 slot) {
        super(material, slot, TechRebornConfig.nanoSuitCapacity, RcEnergyTier.HIGH);
        switch (slot) {
            case field_41934: 
            case field_41937: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(1).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(5).toughness(3).knockback(1.0).build();
                break;
            }
            case field_41935: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(3).knockback(1.0).build();
                break;
            }
            case field_41936: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(3).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(3).knockback(1.0).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slot type");
            }
        }
    }

    public long getEnergyMaxOutput() {
        return 0L;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return HashMultimap.create();
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 equipmentSlot) {
        if (equipmentSlot != this.method_7685()) {
            return ImmutableMultimap.of();
        }
        class_2487 nbt = stack.method_7948();
        if (this.getStoredEnergy(stack) > 0L) {
            if (nbt.method_10545("HideFlags")) {
                return this.fullSuitAttributes;
            }
            return this.hasPowerAttributes;
        }
        return this.noPowerAttributes;
    }

    public void tickArmor(class_1799 stack, boolean hasFullSuit, class_1657 playerEntity) {
        class_2487 nbt = stack.method_7948();
        if (Objects.requireNonNull(this.method_7685()) == class_1304.field_6169) {
            if (nbt.method_10577("isActive") && this.tryUseEnergy(stack, TechRebornConfig.suitNightVisionCost)) {
                playerEntity.method_6092(new class_1293(class_1294.field_5925, 220, 1, false, false));
            } else {
                playerEntity.method_6016(class_1294.field_5925);
            }
        }
        if (nbt.method_10545("HideFlags")) {
            if (!hasFullSuit) {
                nbt.method_10551("HideFlags");
            }
        } else if (hasFullSuit) {
            nbt.method_10569("HideFlags", class_1799.class_5422.field_25769.method_30269());
        }
    }

    public void onRemoved(class_1657 playerEntity) {
        playerEntity.method_6016(class_1294.field_5925);
        class_1799 stack = playerEntity.field_7498.method_34255();
        if (stack.method_7909() instanceof NanoSuitItem) {
            class_2487 nbt = stack.method_7948();
            nbt.method_10551("HideFlags");
            nbt.method_10551("isTicking");
        } else {
            playerEntity.method_31548().field_7547.forEach(itemStack -> {
                if (itemStack.method_7909() instanceof NanoSuitItem) {
                    class_2487 nbt = itemStack.method_7948();
                    nbt.method_10551("HideFlags");
                    nbt.method_10551("isTicking");
                }
            });
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.field_41933 == class_1738.class_8051.field_41934) {
            ItemUtils.buildActiveTooltip((class_1799)stack, tooltip);
        }
    }

    public void appendArmorTooltip(class_1799 stack, List<class_2561> tooltip, boolean shift) {
        ArrayList<class_2561> buffer = new ArrayList<class_2561>();
        if (this.getStoredEnergy(stack) > 0L) {
            if (stack.method_7948().method_10545("HideFlags")) {
                buffer.add((class_2561)class_2561.method_43473());
                buffer.add((class_2561)AttributeModifierBuilder.text(this.method_7685()).method_27692(class_124.field_1080));
                if (shift) {
                    AttributeModifierBuilder.appendText(buffer, this.fullSuitAttributes, class_124.field_1078);
                } else {
                    AttributeModifierBuilder.appendText(buffer, this.hasPowerAttributes, class_124.field_1078);
                    buffer.add((class_2561)class_2561.method_43473());
                    buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.full_suit").method_27692(class_124.field_1054));
                    AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1054);
                }
            } else if (shift) {
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
            }
        } else {
            if (!shift && stack.method_7948().method_10545("isTicking")) {
                return;
            }
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.power").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendDiffText(buffer, this.noPowerAttributes, this.hasPowerAttributes, class_124.field_1078);
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
        }
        AttributeModifierBuilder.appendEnd(tooltip, buffer);
    }
}

