/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.registry.recipes.objects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public record EntityObject(com.teamresourceful.bytecodecs.utils.Either<class_1299<?>, class_6862<class_1299<?>>> entity) {
    static int cycleCounter = 0;
    static int cycleAmount = 0;
    static class_1299<?> currentEntity = null;

    public static EntityObject of(class_1299<?> entity) {
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft(entity));
    }

    public static EntityObject of(class_6862<class_1299<?>> entity) {
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight(entity));
    }

    public static EntityObject fromJson(JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        if (object.has("entity")) {
            JsonElement entity = object.get("entity");
            String entityName = entity.getAsString();
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft((Object)((class_1299)class_7923.field_41177.method_10223(new class_2960(entityName)))));
        }
        if (object.has("tag")) {
            JsonElement tag = object.get("tag");
            String tagName = tag.getAsString();
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight((Object)class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)new class_2960(tagName))));
        }
        throw new IllegalArgumentException("Invalid entity object json");
    }

    public static JsonElement toJson(EntityObject entityObject) {
        JsonObject object = new JsonObject();
        if (entityObject.entity.isLeft()) {
            object.addProperty("entity", class_7923.field_41177.method_10221((Object)((class_1299)entityObject.entity.left().get())).toString());
            return object;
        }
        object.addProperty("tag", ((class_6862)entityObject.entity.right().get()).comp_327().toString());
        return object;
    }

    public static EntityObject fromNetwork(class_2540 buf) {
        if (buf.readBoolean()) {
            return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofLeft((Object)((class_1299)class_7923.field_41177.method_10223(buf.method_10810()))));
        }
        return new EntityObject(com.teamresourceful.bytecodecs.utils.Either.ofRight((Object)class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)buf.method_10810())));
    }

    public void toNetwork(class_2540 buf) {
        if (this.entity.isLeft()) {
            buf.writeBoolean(true);
            buf.method_10812(class_7923.field_41177.method_10221((Object)((class_1299)this.entity.left().get())));
        } else {
            buf.writeBoolean(false);
            buf.method_10812(((class_6862)this.entity.right().get()).comp_327());
        }
    }

    public boolean matches(class_1299<?> entity) {
        if (this.entity.isLeft()) {
            return ((class_1299)this.entity.left().get()).equals(entity);
        }
        return entity.method_20210((class_6862)this.entity.right().get());
    }

    public class_1299<?> getCycling() {
        if (this.entity.isLeft()) {
            return (class_1299)this.entity.left().get();
        }
        if (cycleCounter == 0) {
            ArrayList<class_1299<?>> entityTypes = this.getEntityTypes();
            currentEntity = entityTypes.get(0);
        }
        if (cycleCounter >= 100) {
            cycleCounter = 1;
            currentEntity = this.getEntityTypes().get(cycleAmount);
        }
        if (++cycleAmount >= this.getEntityTypes().size()) {
            cycleAmount = 0;
        }
        ++cycleCounter;
        return currentEntity;
    }

    public class_1799[] spawnEggs() {
        ArrayList<class_1299<?>> entityTypes = this.getEntityTypes();
        class_1799[] spawnEggs = new class_1799[entityTypes.size()];
        for (int i = 0; i < entityTypes.size(); ++i) {
            spawnEggs[i] = class_1826.method_8019(entityTypes.get(i)).method_7854();
        }
        return spawnEggs;
    }

    private ArrayList<class_1299<?>> getEntityTypes() {
        ArrayList entityTypes = new ArrayList();
        class_7923.field_41177.method_40286((class_6862)this.entity.right().get()).forEach(entityTypeHolder -> {
            Either either = entityTypeHolder.method_40229();
            if (either.left().isPresent()) {
                entityTypes.add((class_1299)class_7923.field_41177.method_29107((class_5321)either.left().get()));
            } else {
                entityTypes.add((class_1299)either.right().get());
            }
        });
        return entityTypes;
    }
}

