/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.common.utils.files.GlobalStorage;
import dev.mayaqq.estrogen.Estrogen;
import dev.mayaqq.estrogen.client.cosmetics.DownloadedAsset;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmeticTexture {
    public static final String NAMESPACE = "estrogen_cosmetic";
    public static final Path CACHE = GlobalStorage.getCacheDirectory((String)"estrogen").resolve("cosmetics").resolve("textures");
    private final String id;
    private final String texture;
    private final class_2960 location;
    private class_1049 img;

    public static CosmeticTexture fromLocalFile(String id, File file) {
        CosmeticTexture tex = new CosmeticTexture(id, file);
        tex.img = new DownloadableTexture(file, id, tex.location);
        class_310.method_1551().method_1531().method_4616(tex.location, (class_1044)tex.img);
        return tex;
    }

    private CosmeticTexture(String id, File file) {
        this.id = id;
        this.texture = id;
        this.location = new class_2960(NAMESPACE, "textures/cosmetics" + this.id);
    }

    public CosmeticTexture(String texture) {
        this.id = DownloadedAsset.getUrlHash(texture);
        this.texture = texture;
        this.location = new class_2960(NAMESPACE, "textures/cosmetics/" + this.id);
    }

    public class_2960 getResourceLocation() {
        this.checkOrDownload();
        return this.location;
    }

    public String getTexture() {
        return this.texture;
    }

    public void checkOrDownload() {
        if (this.img != null || this.texture == null) {
            return;
        }
        this.img = new DownloadableTexture(CACHE.resolve(this.id).toFile(), this.texture, this.location);
        class_310.method_1551().method_1531().method_4616(this.location, (class_1044)this.img);
    }

    public static class DownloadableTexture
    extends class_1049 {
        @Nullable
        private final File file;
        @Nullable
        private final String url;
        @Nullable
        private CompletableFuture<Void> future;
        private boolean uploaded;

        public DownloadableTexture(@Nullable File file, @Nullable String url, class_2960 location) {
            super(location);
            this.file = file;
            this.url = url;
        }

        private void loadCallback(class_1011 image) {
            class_310.method_1551().execute(() -> {
                this.uploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(image));
                } else {
                    this.upload(image);
                }
            });
        }

        private void upload(class_1011 image) {
            TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
            image.method_4301(0, 0, 0, true);
        }

        public void method_4625(@NotNull class_3300 manager) {
            class_310.method_1551().execute(() -> {
                if (!this.uploaded) {
                    try {
                        super.method_4625(manager);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.uploaded = true;
                }
            });
            if (this.future == null) {
                Optional nativeimage;
                Optional<Object> optional = nativeimage = this.file != null && this.file.isFile() ? this.load(() -> FileUtils.openInputStream((File)this.file)) : Optional.empty();
                if (nativeimage.isPresent()) {
                    this.loadCallback((class_1011)nativeimage.get());
                } else {
                    this.future = DownloadedAsset.runDownload(this.url, this.file, stream -> this.load(() -> stream).ifPresent(this::loadCallback));
                }
            }
        }

        private Optional<class_1011> load(Callable<InputStream> stream) {
            try {
                return Optional.of(class_1011.method_4309((InputStream)stream.call()));
            }
            catch (Exception ex) {
                Estrogen.LOGGER.error("Failed to load cosmetic texture: {}", (Object)this.url, (Object)ex);
                return Optional.empty();
            }
        }
    }
}

