/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics;

import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.utils.files.GlobalStorage;
import dev.mayaqq.estrogen.client.cosmetics.DownloadedAsset;
import dev.mayaqq.estrogen.client.cosmetics.EstrogenCosmetics;
import dev.mayaqq.estrogen.client.cosmetics.model.BakedCosmeticModel;
import dev.mayaqq.estrogen.client.cosmetics.model.CosmeticModelBakery;
import dev.mayaqq.estrogen.client.cosmetics.model.PreparedModel;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.minecraft.class_8144;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public class CosmeticModel
extends DownloadedAsset<PreparedModel> {
    public static final Path CACHE = GlobalStorage.getCacheDirectory((String)"estrogen").resolve("cosmetics").resolve("models");
    private static final Vector3f DEFAULT_SIZE = new Vector3f(16.0f, 16.0f, 16.0f);
    private volatile BakedCosmeticModel result;
    private Vector3f modelSize = DEFAULT_SIZE;

    public static CosmeticModel fromLocalFile(File file) {
        if (!file.isFile()) {
            EstrogenCosmetics.LOGGER.error("Invalid file");
        }
        CosmeticModel model = new CosmeticModel("");
        model.load(file, "");
        return model;
    }

    public CosmeticModel(String url) {
        super(CACHE, url);
    }

    public Optional<BakedCosmeticModel> get() {
        this.checkOrDownload();
        return Optional.ofNullable(this.result);
    }

    public Vector3fc getModelSize() {
        this.checkOrDownload();
        if (this.modelSize == DEFAULT_SIZE) {
            this.modelSize = (Vector3f)class_8144.method_49078((Object)this.result, BakedCosmeticModel::computeModelSize, (Object)DEFAULT_SIZE);
        }
        return this.modelSize;
    }

    @Override
    protected void onLoad(PreparedModel object) {
        try {
            this.result = CosmeticModelBakery.bake(object);
        }
        catch (Exception e) {
            EstrogenCosmetics.LOGGER.error("Failed to bake cosmetic model: {}", (Object)this.url, (Object)e);
        }
    }

    @Override
    protected Optional<PreparedModel> read(Callable<Reader> supplier) {
        Optional optional;
        block8: {
            Reader reader = supplier.call();
            try {
                optional = PreparedModel.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)EstrogenCosmetics.LOGGER).error(arg_0));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    EstrogenCosmetics.LOGGER.error("Failed to load cosmetic model: {}", (Object)this.url, (Object)ex);
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }
}

