/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics;

import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.utils.files.GlobalStorage;
import dev.mayaqq.estrogen.client.cosmetics.DownloadedAsset;
import dev.mayaqq.estrogen.client.cosmetics.EstrogenCosmetics;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.AnimationDefinition;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.Callable;

public class CosmeticAnimation
extends DownloadedAsset<AnimationDefinition> {
    public static final Path CACHE = GlobalStorage.getCacheDirectory((String)"estrogen").resolve("cosmetics").resolve("animations");
    private volatile AnimationDefinition result;

    public CosmeticAnimation(String url) {
        super(CACHE, url);
    }

    public static CosmeticAnimation fromLocalFile(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File is not a file");
        }
        CosmeticAnimation animation = new CosmeticAnimation("");
        animation.load(file, "");
        return animation;
    }

    public Optional<AnimationDefinition> getResult() {
        this.checkOrDownload();
        return Optional.ofNullable(this.result);
    }

    @Override
    protected void onLoad(AnimationDefinition definition) {
        this.result = definition;
    }

    @Override
    protected Optional<AnimationDefinition> read(Callable<Reader> readerSource) {
        Optional optional;
        block8: {
            Reader reader = readerSource.call();
            try {
                optional = AnimationDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).resultOrPartial(err -> EstrogenCosmetics.LOGGER.error("Failed to read cosmetic from url [{}]: {}", (Object)this.url, err));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    EstrogenCosmetics.LOGGER.error("Failed to load cosmetic from url [{}]", (Object)this.url, (Object)e);
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }
}

