/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.config;

import com.github.legoatoom.connectiblechains.networking.packet.ConfigSyncPayload;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@Config(name="connectiblechains")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static final transient boolean IS_DEBUG_ENV = FabricLoader.getInstance().isDevelopmentEnvironment();
    @ConfigEntry.Gui.Tooltip(count=3)
    private float chainHangAmount = 8.0f;
    @ConfigEntry.BoundedDiscrete(max=32L)
    @ConfigEntry.Gui.Tooltip(count=2)
    private int maxChainRange = 16;
    @ConfigEntry.BoundedDiscrete(min=1L, max=8L)
    @ConfigEntry.Gui.Tooltip
    private int quality = 4;
    @ConfigEntry.Gui.Tooltip
    private boolean showToolTip = true;

    public float getChainHangAmount() {
        return this.chainHangAmount;
    }

    public void setChainHangAmount(float chainHangAmount) {
        this.chainHangAmount = chainHangAmount;
    }

    public int getMaxChainRange() {
        return this.maxChainRange;
    }

    public void setMaxChainRange(int maxChainRange) {
        this.maxChainRange = maxChainRange;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public boolean doDebugDraw() {
        return IS_DEBUG_ENV && class_310.method_1551().field_1690.field_1866;
    }

    public void syncToClients(MinecraftServer server) {
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            this.syncToClient(player);
        }
    }

    public void syncToClient(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)new ConfigSyncPayload(this.chainHangAmount, this.maxChainRange));
    }

    public ModConfig copyFrom(ModConfig config) {
        this.chainHangAmount = config.chainHangAmount;
        this.maxChainRange = config.maxChainRange;
        this.quality = config.quality;
        this.showToolTip = config.showToolTip;
        return this;
    }

    public boolean doShowToolTip() {
        return this.showToolTip;
    }
}

