/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.compat.jei.category.ApplePressFermentingCategory;
import net.satisfy.vinery.core.compat.jei.category.ApplePressMashingCategory;
import net.satisfy.vinery.core.compat.jei.category.FermentationBarrelCategory;
import net.satisfy.vinery.core.compat.jei.transfer.FermentationTransferInfo;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class VineryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FermentationBarrelCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ApplePressFermentingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ApplePressMashingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 rm = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        List fermentationBarrelRecipes = rm.method_30027((class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get());
        registration.addRecipes(FermentationBarrelCategory.FERMENTATION_BARREL, fermentationBarrelRecipes);
        List applePressRecipes = rm.method_30027((class_3956)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get());
        registration.addRecipes(ApplePressFermentingCategory.APPLE_PRESS_TYPE, applePressRecipes);
        List applePressMashingRecipes = rm.method_30027((class_3956)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get());
        registration.addRecipes(ApplePressMashingCategory.APPLE_PRESS_MASHING_TYPE, applePressMashingRecipes);
    }

    @NotNull
    public class_2960 getPluginUid() {
        return Vinery.identifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new FermentationTransferInfo());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.FERMENTATION_BARREL.get()).method_8389().method_7854(), new RecipeType[]{FermentationBarrelCategory.FERMENTATION_BARREL});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.APPLE_PRESS.get()).method_8389().method_7854(), new RecipeType[]{ApplePressFermentingCategory.APPLE_PRESS_TYPE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.APPLE_PRESS.get()).method_8389().method_7854(), new RecipeType[]{ApplePressMashingCategory.APPLE_PRESS_MASHING_TYPE});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, class_1856 ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }

    private static void addItemStackInputSlot(IRecipeLayoutBuilder builder, class_1799 itemStack) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 97, 45).addItemStack(itemStack);
    }

    private static void addItemStackOutputSlot(IRecipeLayoutBuilder builder, class_1799 itemStack) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 77, 4).addItemStack(itemStack);
    }

    public static void buildSlotsFromRecipe(IRecipeLayoutBuilder builder, FermentationBarrelRecipe recipe) {
        int BOTTOM_ROW_Y = 45;
        class_2371<class_1856> recipeIngredients = recipe.method_8117();
        int ingredientCount = recipeIngredients.size();
        if (ingredientCount >= 1) {
            VineryJEIPlugin.addSlot(builder, 41, 45, (class_1856)recipeIngredients.get(0));
        }
        if (ingredientCount >= 2) {
            VineryJEIPlugin.addSlot(builder, 59, 45, (class_1856)recipeIngredients.get(1));
        }
        if (ingredientCount >= 3) {
            VineryJEIPlugin.addSlot(builder, 77, 45, (class_1856)recipeIngredients.get(2));
        }
        VineryJEIPlugin.addItemStackInputSlot(builder, ((class_1792)ObjectRegistry.WINE_BOTTLE.get()).method_7854());
        assert (class_310.method_1551().field_1687 != null);
        VineryJEIPlugin.addItemStackOutputSlot(builder, recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
    }
}

