/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.util.ImplementedInventory;
import net.satisfy.vinery.core.util.JuiceUtil;
import net.satisfy.vinery.core.util.WineYears;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends class_2586
implements ImplementedInventory,
class_3908 {
    private static final int INVENTORY_SIZE = 6;
    public static final int GRAPEJUICE_INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_GENERAL = 5;
    public static final int WINE_BOTTLE_SLOT = 4;
    private class_2371<class_1799> inventory;
    private int fermentationTime = 0;
    private int fluidLevel = 0;
    private String juiceType = "";
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FermentationBarrelBlockEntity.this.fermentationTime;
                case 1 -> PlatformHelper.getTotalFermentationTime();
                case 2 -> FermentationBarrelBlockEntity.this.fluidLevel;
                case 3 -> FermentationBarrelBlockEntity.this.getJuiceTypeValue();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FermentationBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    FermentationBarrelBlockEntity.this.updateTotalFermentationTime();
                    break;
                }
                case 2: {
                    FermentationBarrelBlockEntity.this.setFluidLevel(value);
                    break;
                }
                case 3: {
                    FermentationBarrelBlockEntity.this.juiceType = FermentationBarrelBlockEntity.this.getJuiceTypeFromValue(value);
                    break;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public FermentationBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.FERMENTATION_BARREL_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    }

    public void updateTotalFermentationTime() {
        this.method_5431();
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(int fluidLevel) {
        this.fluidLevel = fluidLevel;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    public void setJuiceType(String juiceType) {
        this.juiceType = juiceType;
        this.method_5431();
    }

    private int getJuiceTypeValue() {
        return switch (this.juiceType) {
            case "white_general" -> 0;
            case "red_general" -> 1;
            case "white_savanna" -> 2;
            case "red_savanna" -> 3;
            case "white_taiga" -> 4;
            case "red_taiga" -> 5;
            case "white_jungle" -> 6;
            case "red_jungle" -> 7;
            case "apple" -> 8;
            case "red_crimson" -> 9;
            case "white_warped" -> 10;
            default -> -1;
        };
    }

    private String getJuiceTypeFromValue(int value) {
        return switch (value) {
            case 0 -> "white_general";
            case 1 -> "red_general";
            case 2 -> "white_savanna";
            case 3 -> "red_savanna";
            case 4 -> "white_taiga";
            case 5 -> "red_taiga";
            case 6 -> "white_jungle";
            case 7 -> "red_jungle";
            case 8 -> "apple";
            case 9 -> "red_crimson";
            case 10 -> "white_warped";
            default -> "";
        };
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.fermentationTime = nbt.method_10550("FermentationTime");
        this.fluidLevel = nbt.method_10550("FluidLevel");
        this.juiceType = nbt.method_10558("JuiceType");
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("FermentationTime", this.fermentationTime);
        nbt.method_10569("FluidLevel", this.fluidLevel);
        nbt.method_10582("JuiceType", this.juiceType);
    }

    public static void tick(class_1937 world, class_2338 pos, FermentationBarrelBlockEntity blockEntity) {
        class_1799 stack;
        if (world.field_9236) {
            return;
        }
        if (blockEntity.fluidLevel == 0) {
            blockEntity.setJuiceType("");
        }
        class_5455 access = world.method_30349();
        FermentationBarrelRecipe recipe = world.method_8433().method_8132((class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get(), (class_1263)blockEntity, world).orElse(null);
        if (blockEntity.canCraft(recipe, access)) {
            ++blockEntity.fermentationTime;
            if (blockEntity.fermentationTime >= PlatformHelper.getTotalFermentationTime()) {
                blockEntity.fermentationTime = 0;
                blockEntity.craft(recipe, access);
            }
        } else {
            blockEntity.fermentationTime = 0;
        }
        if (JuiceUtil.isJuice(stack = blockEntity.method_5438(0))) {
            String newJuiceType = JuiceUtil.getJuiceType(stack);
            if (blockEntity.fluidLevel == 0 || blockEntity.juiceType.equals(newJuiceType)) {
                blockEntity.setJuiceType(newJuiceType);
                int currentLevel = blockEntity.getFluidLevel();
                int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
                int juiceCount = stack.method_7947();
                int juicesToConsume = Math.min(juiceCount, 4);
                int fluidIncrease = juicesToConsume * PlatformHelper.getMaxFluidIncrease();
                int newFluidLevel = Math.min(currentLevel + fluidIncrease, maxFluidLevel);
                int actualFluidIncrease = newFluidLevel - currentLevel;
                int actualJuicesConsumed = actualFluidIncrease / PlatformHelper.getMaxFluidIncrease();
                if (actualJuicesConsumed > 0) {
                    blockEntity.setFluidLevel(newFluidLevel);
                    stack.method_7934(actualJuicesConsumed);
                    if (stack.method_7960()) {
                        blockEntity.method_5447(0, class_1799.field_8037);
                    } else {
                        blockEntity.method_5447(0, stack);
                    }
                    class_1799 wineBottleStack = new class_1799((class_1935)ObjectRegistry.WINE_BOTTLE.get(), actualJuicesConsumed);
                    class_1799 existingOutput = blockEntity.method_5438(4);
                    if (existingOutput.method_7960()) {
                        blockEntity.method_5447(4, wineBottleStack);
                    } else if (existingOutput.method_31574(wineBottleStack.method_7909()) && existingOutput.method_7947() + wineBottleStack.method_7947() <= existingOutput.method_7914()) {
                        existingOutput.method_7933(wineBottleStack.method_7947());
                        blockEntity.method_5447(4, existingOutput);
                    } else {
                        class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)(pos.method_10264() + 1), (double)((double)pos.method_10260() + 0.5), (class_1799)wineBottleStack);
                    }
                }
            }
        }
    }

    private boolean canCraft(FermentationBarrelRecipe recipe, class_5455 access) {
        class_1799 wineBottle;
        if (recipe == null || recipe.method_8110(access).method_7960()) {
            return false;
        }
        if (this.areIngredientsEmpty()) {
            return false;
        }
        if (this.fluidLevel < recipe.getJuiceAmount()) {
            return false;
        }
        if (!this.juiceType.equals(recipe.getJuiceType())) {
            return false;
        }
        if (recipe.isWineBottleRequired() && ((wineBottle = this.method_5438(4)).method_7960() || !wineBottle.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        class_1799 recipeOutput = recipe.method_8110(access);
        if (recipeOutput.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get())) {
            class_1799 existingWineBottle = this.method_5438(4);
            if (existingWineBottle.method_7960()) {
                return true;
            }
            return existingWineBottle.method_31574(recipeOutput.method_7909()) && existingWineBottle.method_7947() + recipeOutput.method_7947() <= existingWineBottle.method_7914();
        }
        class_1799 existingOutput = this.method_5438(5);
        if (existingOutput.method_7960()) {
            return true;
        }
        return existingOutput.method_31574(recipeOutput.method_7909()) && existingOutput.method_7947() + recipeOutput.method_7947() <= existingOutput.method_7914();
    }

    private boolean areIngredientsEmpty() {
        for (int i = 1; i < 4; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void craft(FermentationBarrelRecipe recipe, class_5455 access) {
        class_1799 wineBottle;
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110(access).method_7972();
        class_1799 existingOutput = this.method_5438(5);
        if (existingOutput.method_7960()) {
            this.method_5447(5, recipeOutput);
        } else if (existingOutput.method_31574(recipeOutput.method_7909()) && existingOutput.method_7947() + recipeOutput.method_7947() <= existingOutput.method_7914()) {
            existingOutput.method_7933(recipeOutput.method_7947());
            this.method_5447(5, existingOutput);
        } else {
            assert (this.field_11863 != null);
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)(this.field_11867.method_10264() + 1), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)recipeOutput);
        }
        if (recipe.isWineBottleRequired() && !(wineBottle = this.method_5438(4)).method_7960() && wineBottle.method_7947() > 0) {
            wineBottle.method_7934(1);
            this.method_5447(4, wineBottle);
        }
        int newFluidLevel = this.fluidLevel - recipe.getJuiceAmount();
        this.setFluidLevel(newFluidLevel);
        block0: for (class_1856 ingredient : recipe.method_8117()) {
            for (int i = 1; i < 4; ++i) {
                class_1799 slotStack = this.method_5438(i);
                if (!ingredient.method_8093(slotStack)) continue;
                slotStack.method_7934(1);
                if (slotStack.method_7960()) {
                    this.method_5447(i, class_1799.field_8037);
                    continue block0;
                }
                this.method_5447(i, slotStack);
                continue block0;
            }
        }
        WineYears.setWineYear(recipeOutput, this.field_11863);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean sameItem = !stack.method_7960() && class_1799.method_7973((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!sameItem && this.isIngredientSlot(slot) && this.areIngredientsEmpty()) {
            this.fermentationTime = 0;
            this.method_5431();
        }
    }

    private boolean isIngredientSlot(int slot) {
        return slot >= 1 && slot <= 3;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        return this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new FermentationBarrelGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    @Override
    public int method_5439() {
        return this.inventory.size();
    }

    @Override
    public boolean method_5442() {
        for (class_1799 itemstack : this.inventory) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public class_1799 method_5438(int index) {
        return (class_1799)this.inventory.get(index);
    }

    @Override
    @NotNull
    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.inventory, (int)index, (int)count);
    }

    @Override
    @NotNull
    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.inventory, (int)index);
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
    }

    private boolean isIngredient(class_1799 stack) {
        if (this.field_11863 == null) {
            return false;
        }
        return this.field_11863.method_8433().method_30027((class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(stack)));
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side == class_2350.field_11036) {
            return new int[]{0, 4};
        }
        if (side == class_2350.field_11033) {
            return new int[]{5};
        }
        if (side.method_10166().method_10179()) {
            return new int[]{5, 4, 1, 2, 3};
        }
        return new int[0];
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (direction == class_2350.field_11036) {
            if (index == 0 && JuiceUtil.isJuice(stack)) {
                return this.hasSpace(index, stack);
            }
            if (index == 4 && stack.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get())) {
                return this.hasSpace(index, stack);
            }
        } else {
            assert (direction != null);
            if (direction.method_10166().method_10179()) {
                if (index >= 1 && index <= 3 && this.isIngredient(stack)) {
                    return this.hasSpace(index, stack);
                }
                if (index == 4 && stack.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get())) {
                    return this.hasSpace(index, stack);
                }
            }
        }
        return false;
    }

    private boolean hasSpace(int index, class_1799 stack) {
        class_1799 slotStack = this.method_5438(index);
        if (slotStack.method_7960()) {
            return true;
        }
        if (class_1799.method_31577((class_1799)slotStack, (class_1799)stack)) {
            return slotStack.method_7947() + stack.method_7947() <= slotStack.method_7914();
        }
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return (direction == class_2350.field_11033 || direction.method_10166().method_10179()) && index == 5;
    }
}

