/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.platform.PlatformHelper;

@Environment(value=EnvType.CLIENT)
public class FermentationBarrelGui
extends class_465<FermentationBarrelGuiHandler> {
    public static final class_2960 BACKGROUND = Vinery.identifier("textures/gui/fermentation_barrel_gui.png");
    private static final int FLUID_WIDTH = 20;
    private static final int FLUID_X = 82;
    private static final int FLUID_Y = 44;
    private static final int CRAFT_PROGRESS_TEXTURE_X = 176;
    private static final int CRAFT_PROGRESS_TEXTURE_Y = 0;
    private static final int CRAFT_PROGRESS_WIDTH = 11;
    private static final int CRAFT_PROGRESS_HEIGHT = 29;
    private static final int CRAFT_PROGRESS_GUI_X = 122;
    private static final int CRAFT_PROGRESS_GUI_Y = 20;
    private static final int CRAFT_PROGRESS_GUI_HEIGHT = 29;

    public FermentationBarrelGui(FermentationBarrelGuiHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 166;
        this.field_25267 = 8;
        this.field_25268 = 6;
        this.field_25269 = 8;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_2561 tooltip;
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (this.isMouseOverFluidArea(mouseX, mouseY)) {
            tooltip = this.getFluidTooltip();
            guiGraphics.method_51438(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverCraftingTimeArea(mouseX, mouseY)) {
            tooltip = this.getCraftingTimeTooltip();
            guiGraphics.method_51438(this.field_22793, tooltip, mouseX, mouseY);
        }
    }

    private class_2561 getFluidTooltip() {
        String juiceType = ((FermentationBarrelGuiHandler)this.field_2797).getJuiceType();
        int fluidLevel = ((FermentationBarrelGuiHandler)this.field_2797).getFluidLevel();
        int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
        double percentage = (double)fluidLevel / (double)maxFluidLevel * 100.0;
        String percentageStr = String.format("%.2f", percentage);
        if (juiceType.startsWith("red")) {
            String region = juiceType.substring(4);
            return class_2561.method_43469((String)("tooltip.vinery.fermentation_barrel.red_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.startsWith("white")) {
            String region = juiceType.substring(6);
            return class_2561.method_43469((String)("tooltip.vinery.fermentation_barrel.white_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.equals("apple")) {
            return class_2561.method_43469((String)"tooltip.vinery.fermentation_barrel.apple_juice_with_percentage", (Object[])new Object[]{percentageStr});
        }
        return class_2561.method_43471((String)"tooltip.vinery.fermentation_barrel.empty");
    }

    private class_2561 getCraftingTimeTooltip() {
        int currentTicks;
        int totalTicks = ((FermentationBarrelGuiHandler)this.field_2797).data.method_17390(1);
        int remainingTicks = totalTicks - (currentTicks = ((FermentationBarrelGuiHandler)this.field_2797).data.method_17390(0));
        if (remainingTicks > 0) {
            int seconds = remainingTicks / 20;
            int minutes = seconds / 60;
            String formattedTime = String.format("%d:%02d Seconds", minutes, seconds %= 60);
            return class_2561.method_43469((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{formattedTime});
        }
        return class_2561.method_43469((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{"0:00 Seconds"});
    }

    private boolean isMouseOverFluidArea(int mouseX, int mouseY) {
        int fluidAreaLeft = this.field_2776 + 82 - 1;
        int fluidAreaTop = this.field_2800 + 44 - 5;
        int fluidAreaRight = this.field_2776 + 82 + 20 + 1;
        int fluidAreaBottom = this.field_2800 + 44 + 10;
        return mouseX >= fluidAreaLeft && mouseX <= fluidAreaRight && mouseY >= fluidAreaTop && mouseY <= fluidAreaBottom;
    }

    private boolean isMouseOverCraftingTimeArea(int mouseX, int mouseY) {
        int totalTicks = ((FermentationBarrelGuiHandler)this.field_2797).data.method_17390(1);
        int currentTicks = ((FermentationBarrelGuiHandler)this.field_2797).data.method_17390(0);
        if (totalTicks <= 0 || currentTicks >= totalTicks) {
            return false;
        }
        int craftingTimeAreaLeft = this.field_2776 + 122;
        int craftingTimeAreaTop = this.field_2800 + 20;
        int craftingTimeAreaRight = this.field_2776 + 122 + 11;
        int craftingTimeAreaBottom = this.field_2800 + 20 + 29;
        return mouseX >= craftingTimeAreaLeft && mouseX <= craftingTimeAreaRight && mouseY >= craftingTimeAreaTop && mouseY <= craftingTimeAreaBottom;
    }

    public static void drawJuiceBar(class_332 guiGraphics, String juiceType, int juiceAmount, int originX, int originY) {
        int MAX_FLUID = PlatformHelper.getMaxFluidLevel();
        int scaledWidth = (int)((double)juiceAmount / (double)MAX_FLUID * 20.0);
        scaledWidth = Math.max(0, Math.min(20, scaledWidth));
        int TEXTURE_X_START = 176;
        int TEXTURE__START = juiceType.startsWith("red") ? 29 : (juiceType.startsWith("white") ? 33 : (juiceType.equals("apple") ? 37 : 0));
        guiGraphics.method_25302(BACKGROUND, originX, originY, 176, TEXTURE__START, scaledWidth, 4);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND);
        int x = this.field_2776;
        int y = this.field_2800;
        guiGraphics.method_25302(BACKGROUND, x, y, 0, 0, this.field_2792, this.field_2779);
        FermentationBarrelGui.drawJuiceBar(guiGraphics, ((FermentationBarrelGuiHandler)this.field_2797).getJuiceType(), ((FermentationBarrelGuiHandler)this.field_2797).getFluidLevel(), x + 82, y + 44);
        this.renderCraftingProgress(guiGraphics, x, y);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51433(this.field_22793, this.field_22785.getString(), this.field_25267, this.field_25268, 0x404040, false);
        guiGraphics.method_51433(this.field_22793, this.field_29347.getString(), this.field_25269, this.field_25270, 0x404040, false);
    }

    protected void renderCraftingProgress(class_332 guiGraphics, int guiLeft, int guiTop) {
        int filledHeight = ((FermentationBarrelGuiHandler)this.field_2797).getScaledProgress(29);
        int drawY = guiTop + 20 + (29 - filledHeight);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND);
        guiGraphics.method_25302(BACKGROUND, guiLeft + 122, drawY, 176, 0 + (29 - filledHeight), 11, filledHeight);
    }
}

