/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

public enum RcEnergyTier {
    MICRO(8, 8),
    LOW(32, 32),
    MEDIUM(128, 128),
    HIGH(512, 512),
    EXTREME(2048, 2048),
    INSANE(8192, 8192),
    INFINITE(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private final int maxInput;
    private final int maxOutput;

    private RcEnergyTier(int maxInput, int maxOutput) {
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public static RcEnergyTier getTier(long power) {
        for (RcEnergyTier tier : RcEnergyTier.values()) {
            if ((long)tier.getMaxInput() < power) continue;
            return tier;
        }
        return INFINITE;
    }
}

