/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.text.DecimalFormat;
import reborncore.RebornCore;

public class PowerSystem {
    public static final String ABBREVIATION = "E";
    private static final char[] magnitude = new char[]{'k', 'M', 'G', 'T'};

    public static String getLocalizedPower(double power) {
        return PowerSystem.getRoundedString(power, ABBREVIATION, true);
    }

    public static String getLocalizedPowerNoSuffix(double power) {
        return PowerSystem.getRoundedString(power, "", true);
    }

    public static String getLocalizedPowerNoFormat(double power) {
        return PowerSystem.getRoundedString(power, ABBREVIATION, false);
    }

    public static String getLocalizedPowerNoSuffixNoFormat(double power) {
        return PowerSystem.getRoundedString(power, "", false);
    }

    public static String getLocalizedPowerFull(double power) {
        return PowerSystem.getFullPower(power, ABBREVIATION);
    }

    public static String getLocalizedPowerFullNoSuffix(double power) {
        return PowerSystem.getFullPower(power, "");
    }

    private static String getFullPower(double power, String units) {
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(RebornCore.locale);
        return formatter.format(power) + " " + units;
    }

    private static String getRoundedString(double originalValue, String units, boolean doFormat) {
        Object ret = "";
        double value = 0.0;
        int i = 0;
        boolean showMagnitude = true;
        double euValue = originalValue;
        if (euValue < 0.0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000.0) {
            doFormat = false;
            showMagnitude = false;
            value = euValue;
        } else if (euValue >= 1000.0) {
            i = 0;
            while (true) {
                if (euValue < 10000.0 && euValue % 1000.0 >= 100.0) {
                    value = Math.floor(euValue / 1000.0);
                    value += (double)((float)euValue % 1000.0f / 1000.0f);
                    break;
                }
                if ((euValue /= 1000.0) < 1000.0) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        if (i > 10) {
            doFormat = false;
            showMagnitude = false;
        } else if (i > 3) {
            value = originalValue;
            showMagnitude = false;
        }
        if (doFormat) {
            DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(RebornCore.locale);
            int idx = ((String)(ret = (String)ret + formatter.format(value))).lastIndexOf(formatter.getDecimalFormatSymbols().getDecimalSeparator());
            if (idx > 0) {
                ret = ((String)ret).substring(0, idx + 2);
            }
        } else {
            ret = i > 10 ? (String)ret + "\u221e" : (String)ret + value;
        }
        if (showMagnitude) {
            ret = (String)ret + magnitude[i];
        }
        if (!units.equals("")) {
            ret = (String)ret + " " + units;
        }
        return ret;
    }
}

