/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config.elements;

import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import reborncore.RebornCore;
import reborncore.client.ClientNetworkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.config.elements.AbstractConfigPopupElement;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.util.Color;

@Environment(value=EnvType.CLIENT)
public class SlotConfigPopupElement
extends AbstractConfigPopupElement {
    private final int id;
    private final boolean allowInput;

    public SlotConfigPopupElement(int slotId, int x, int y, int height, boolean allowInput) {
        super(x, y, height, GuiSprites.SLOT_CONFIG_POPUP, 62, 62, (String[])Stream.concat(Arrays.stream(SlotConfiguration.ExtractConfig.values()).filter(config -> allowInput || config != SlotConfiguration.ExtractConfig.INPUT).map(Enum::name), Stream.of("FIRST", "LAST")).toArray(String[]::new));
        this.id = slotId;
        this.allowInput = allowInput;
    }

    @Override
    public int getPencilColor(String pencil) {
        return switch (pencil) {
            case "INPUT" -> new Color(0, 0, 255, 128).getColor();
            case "OUTPUT" -> new Color(255, 69, 0, 128).getColor();
            case "FIRST", "LAST" -> (this.allowInput ? new Color(0, 0, 255, 128) : new Color(255, 69, 0, 128)).getColor();
            default -> new Color(255, 0, 0, 128).getColor();
        };
    }

    @Override
    public void cycleConfig(class_2350 side, GuiBase<?> guiBase) {
        SlotConfiguration.ExtractConfig nextConfig;
        if (this.pencil != null) {
            switch (this.pencil) {
                case "INPUT": {
                    nextConfig = SlotConfiguration.ExtractConfig.INPUT;
                    break;
                }
                case "OUTPUT": {
                    nextConfig = SlotConfiguration.ExtractConfig.OUTPUT;
                    break;
                }
                case "FIRST": 
                case "LAST": {
                    SlotConfiguration.SlotConfigHolder configHolder = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id);
                    if (configHolder != null) {
                        if (this.pencil.equals("FIRST")) {
                            configHolder.first = side;
                            if (configHolder.last == side) {
                                configHolder.last = null;
                            }
                        } else {
                            configHolder.last = side;
                            if (configHolder.first == side) {
                                configHolder.first = null;
                            }
                        }
                        ClientNetworkManager.sendToServer(ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, configHolder));
                        if (configHolder.getSideDetail(side).getSlotIO().getIoConfig() != SlotConfiguration.ExtractConfig.NONE) {
                            return;
                        }
                    } else {
                        int priority = this.pencil.equals("FIRST") ? side.ordinal() * 10 + 6 : 60 + side.ordinal();
                        ClientNetworkManager.sendToServer(ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, true, true, false, priority));
                    }
                    nextConfig = this.allowInput ? SlotConfiguration.ExtractConfig.INPUT : SlotConfiguration.ExtractConfig.OUTPUT;
                    break;
                }
                default: {
                    SlotConfiguration.SlotConfigHolder configHolder = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id);
                    if (configHolder != null) {
                        if (configHolder.first == side) {
                            configHolder.first = null;
                            ClientNetworkManager.sendToServer(ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, configHolder));
                        } else if (configHolder.last == side) {
                            configHolder.last = null;
                            ClientNetworkManager.sendToServer(ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, configHolder));
                        }
                    }
                    nextConfig = SlotConfiguration.ExtractConfig.NONE;
                    break;
                }
            }
        } else {
            SlotConfiguration.SlotConfig currentSlot = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id).getSideDetail(side);
            nextConfig = currentSlot.getSlotIO().getIoConfig().getNext();
            if (!this.allowInput && nextConfig == SlotConfiguration.ExtractConfig.INPUT) {
                nextConfig = SlotConfiguration.ExtractConfig.OUTPUT;
            }
        }
        SlotConfiguration.SlotIO slotIO = new SlotConfiguration.SlotIO(nextConfig);
        SlotConfiguration.SlotConfig newConfig = new SlotConfiguration.SlotConfig(side, slotIO, this.id);
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketSlotSave(guiBase.be.method_11016(), newConfig);
        ClientNetworkManager.sendToServer(packetSlotSave);
    }

    public void updateCheckBox(String type, GuiBase<?> guiBase) {
        SlotConfiguration.SlotConfigHolder configHolder = guiBase.getMachine().getSlotConfiguration().getSlotDetails(this.id);
        if (configHolder == null) {
            return;
        }
        if (type.equalsIgnoreCase("input")) {
            configHolder.setInput(!configHolder.autoInput());
        }
        if (type.equalsIgnoreCase("output")) {
            configHolder.setOutput(!configHolder.autoOutput());
        }
        if (type.equalsIgnoreCase("filter")) {
            configHolder.setFilter(!configHolder.filter());
        }
        IdentifiedPacket packetSlotSave = ServerBoundPackets.createPacketIOSave(guiBase.be.method_11016(), this.id, configHolder);
        ClientNetworkManager.sendToServer(packetSlotSave);
    }

    @Override
    protected void drawSateColor(class_332 drawContext, GuiBase<?> gui, class_2350 side, int inx, int iny) {
        int sx = inx + this.getX() + gui.getGuiLeft();
        int sy = (iny += 4) + this.getY() + gui.getGuiTop();
        SlotConfiguration.SlotConfigHolder slotConfigHolder = gui.getMachine().getSlotConfiguration().getSlotDetails(this.id);
        if (slotConfigHolder == null) {
            RebornCore.LOGGER.debug("Hmm, this isn't supposed to happen");
            return;
        }
        SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(side);
        Color color = switch (slotConfig.getSlotIO().getIoConfig()) {
            case SlotConfiguration.ExtractConfig.INPUT -> new Color(0, 0, 255, 128);
            case SlotConfiguration.ExtractConfig.OUTPUT -> new Color(255, 69, 0, 128);
            default -> new Color(0, 0, 0, 0);
        };
        drawContext.method_25294(sx, sy, sx + 18, sy + 18, color.getColor());
        if (side == slotConfigHolder.first) {
            this.drawTag(drawContext, gui, sx, sy, "F");
        } else if (side == slotConfigHolder.last) {
            this.drawTag(drawContext, gui, sx, sy, "L");
        }
    }

    protected void drawTag(class_332 drawContext, GuiBase<?> gui, int sx, int sy, String tag) {
        class_327 textRenderer = gui.getTextRenderer();
        class_2561 text = class_2561.method_30163((String)tag);
        drawContext.method_51439(textRenderer, text, sx + 10 - textRenderer.method_1727(tag) / 2, sy + 6, -1, false);
    }
}

