/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets.networking;

import com.telepathicgrunt.the_bumblezone.packets.networking.PacketChannelHelper;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.NetworkDirection;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.server.MinecraftServer;

public class NetworkChannel {
    private final class_2960 channel;

    public NetworkChannel(String modid, String channel) {
        this.channel = new class_2960(modid, channel);
        PacketChannelHelper.registerChannel(this.channel);
    }

    public final <T extends Packet<T>> void registerPacket(NetworkDirection direction, class_2960 id, PacketHandler<T> handler, Class<T> packetClass) {
        if (direction == NetworkDirection.CLIENT_TO_SERVER) {
            PacketChannelHelper.registerC2SPacket(this.channel, id, handler, packetClass);
        } else {
            PacketChannelHelper.registerS2CPacket(this.channel, id, handler, packetClass);
        }
    }

    public final <T extends Packet<T>> void sendToServer(T packet) {
        PacketChannelHelper.sendToServer(this.channel, packet);
    }

    public final <T extends Packet<T>> void sendToPlayer(T packet, class_1657 player) {
        PacketChannelHelper.sendToPlayer(this.channel, packet, player);
    }

    public final <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends class_1657> players) {
        players.forEach(player -> this.sendToPlayer(packet, (class_1657)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.method_3760().method_14571());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T packet, class_1937 level) {
        this.sendToPlayers(packet, level.method_18456());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T packet, class_1937 level, class_2338 pos) {
        class_2802 class_28022;
        class_2818 chunk = level.method_8500(pos);
        if (chunk != null && (class_28022 = level.method_8398()) instanceof class_3215) {
            class_3215 serverCache = (class_3215)class_28022;
            serverCache.field_17254.method_17210(chunk.method_12004(), false).forEach(player -> this.sendToPlayer(packet, (class_1657)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T packet, class_1937 level, class_2338 pos, double range) {
        for (class_1657 player : level.method_18456()) {
            if (!(player.method_24515().method_10262((class_2382)pos) <= range)) continue;
            this.sendToPlayer(packet, player);
        }
    }
}

