/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1551;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EssenceBlockBlue
extends EssenceBlock {
    private static final int ENTITIES_TO_KILL = 50;

    public EssenceBlockBlue() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15984));
    }

    @Override
    public class_2960 getArenaNbt() {
        return new class_2960("the_bumblezone", "essence/blue_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 10800;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.blue_essence_event", class_1259.class_1260.field_5780, class_1259.class_1261.field_5790).method_5406(true);
    }

    @Override
    public class_2960 getEssenceItemReward() {
        return new class_2960("the_bumblezone", "gameplay/rewards/blue_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281(BzStats.CALMING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (entitiesKilled != 50 && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(50 - entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockBlue.SpawnNewEnemy(serverLevel, blockPos, blockState, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                class_1308 mob;
                class_3222 player;
                UUID playerUUID;
                class_5354 neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                class_1297 entity = serverLevel.method_14190(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof class_5354 && !((neutralMob = (class_5354)entity).method_5968() instanceof class_1657)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.method_8503().method_3760().method_14602(playerUUID);
                    neutralMob.method_29514(Integer.MAX_VALUE);
                    neutralMob.method_29513(playerUUID);
                    neutralMob.method_5980((class_1309)player);
                    continue;
                }
                if (!(entity instanceof class_1308) || (mob = (class_1308)entity).method_5968() instanceof class_1657) continue;
                playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
                player = serverLevel.method_8503().method_3760().method_14602(playerUUID);
                mob.method_5980((class_1309)player);
            }
        }
        this.handleGiantBubbles(serverLevel, blockPos);
        float newProgress = entitiesKilled / 50;
        essenceBlockEntity.getEventBar().method_5408(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if (entitiesKilled == 50) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        class_1299 entityTypeToSpawn;
        class_6862<class_1299<?>> enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_NORMAL_ENEMY;
        boolean isStrong = false;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex == 28 || entityToSpawnIndex == 35 || entityToSpawnIndex == 48 || entityToSpawnIndex == 49 || entityToSpawnIndex == 50) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_STRONG_ENEMY;
            isStrong = true;
        } else if (entityToSpawnIndex >= 25) {
            enemyTagToUse = BzTags.ESSENCE_CALMING_ARENA_LATE_NORMAL_ENEMY;
        }
        List entityTypeList = class_7923.field_41177.method_40266(enemyTagToUse).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
        class_2350 direction = class_2350.method_10162((class_5819)serverLevel.method_8409());
        class_1299 class_12992 = entityTypeToSpawn = entityTypeList.isEmpty() ? null : (class_1299)entityTypeList.get(serverLevel.method_8409().method_43048(entityTypeList.size()));
        if (entityTypeToSpawn == null) {
            return;
        }
        class_1297 entity = entityTypeToSpawn.method_47821(serverLevel, blockPos.method_10069(direction.method_10148() * 3, direction.method_10164() * 3, direction.method_10165() * 3), class_3730.field_16461);
        if (entity == null) {
            return;
        }
        entity.method_5780("the_bumblezone.blue_essence_arena");
        eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.method_5667()));
        UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
        class_3222 player = serverLevel.method_8503().method_3760().method_14602(playerUUID);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = player;
            float maxHeart = Math.max(serverPlayer.method_6032(), serverPlayer.method_6063());
            float maxArmor = serverPlayer.method_6096();
            float mobHealthBoost = maxHeart / 15.0f + maxArmor / 20.0f;
            float mobAttackBoost = maxHeart / 25.0f + maxArmor / 10.0f;
            boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
            if (!isEssenced) {
                mobHealthBoost *= 1.5f;
                mobAttackBoost *= 1.5f;
            }
            float timeProgress = 1.0f - (float)essenceBlockEntity.getEventTimer() / (float)((EssenceBlock)blockState.method_26204()).getEventTimeFrame();
            float enemyProgress = essenceBlockEntity.getExtraEventTrackingProgress() / 50;
            float progressDiff = (float)(Math.pow(enemyProgress - timeProgress + 1.0f, 2.0) - 1.0);
            if ((double)progressDiff > 0.1) {
                progressDiff = (float)(Math.pow((double)(enemyProgress - timeProgress) + 0.95, 5.0) - 0.95);
                mobHealthBoost += (float)((int)(progressDiff / 0.025f));
                mobAttackBoost += (float)((int)(progressDiff / 0.1f));
            }
            if (entity instanceof class_1309) {
                class_1324 livingEntityAttributeFollowRange;
                class_1324 livingEntityAttributeFlyingSpeed;
                class_1324 livingEntityAttributeSpeed;
                class_1324 livingEntityAttributeAttack;
                class_1309 livingEntity = (class_1309)entity;
                class_1324 livingEntityAttributeHealth = livingEntity.method_5996(class_5134.field_23716);
                if (livingEntityAttributeHealth != null) {
                    livingEntityAttributeHealth.method_26837(new class_1322(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, class_1322.class_1323.field_6328));
                    livingEntity.method_6025(mobHealthBoost);
                }
                if ((livingEntityAttributeAttack = livingEntity.method_5996(class_5134.field_23721)) != null) {
                    livingEntityAttributeAttack.method_26837(new class_1322(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, class_1322.class_1323.field_6328));
                }
                if ((livingEntityAttributeSpeed = livingEntity.method_5996(class_5134.field_23719)) != null) {
                    livingEntityAttributeSpeed.method_26837(new class_1322(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.04 : 0.08, class_1322.class_1323.field_6328));
                }
                if ((livingEntityAttributeFlyingSpeed = livingEntity.method_5996(class_5134.field_23720)) != null) {
                    livingEntityAttributeFlyingSpeed.method_26837(new class_1322(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", 0.02, class_1322.class_1323.field_6328));
                }
                if ((livingEntityAttributeFollowRange = livingEntity.method_5996(class_5134.field_23717)) != null) {
                    livingEntityAttributeFollowRange.method_26837(new class_1322(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, class_1322.class_1323.field_6328));
                }
            }
            if (entity instanceof class_5354) {
                class_5354 neutralMob = (class_5354)entity;
                neutralMob.method_29514(Integer.MAX_VALUE);
                neutralMob.method_29513(playerUUID);
                neutralMob.method_5980((class_1309)serverPlayer);
            } else if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                List itemList = class_7923.field_41178.method_40266(BzTags.CALMING_ARENA_DROWNED_BONUS_HELD_ITEM).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
                class_1799 bonusItem = itemList.isEmpty() ? class_1799.field_8037 : ((class_1792)itemList.get(serverLevel.method_8409().method_43048(itemList.size()))).method_7854();
                mob.method_5980((class_1309)serverPlayer);
                if (mob instanceof class_1551) {
                    class_1799 helmet;
                    class_1551 drowned = (class_1551)mob;
                    class_1799 swimBoots = class_1802.field_8370.method_7854();
                    swimBoots.method_7978(class_1893.field_9128, 3);
                    drowned.method_24523(swimBoots);
                    drowned.method_5946(class_1304.field_6166, 0.2f);
                    class_1799 leggings = class_1802.field_8570.method_7854();
                    leggings.method_7978(class_1893.field_9097, 1);
                    drowned.method_24523(leggings);
                    drowned.method_5946(class_1304.field_6172, 0.2f);
                    class_1799 chestplate = class_1802.field_8577.method_7854();
                    chestplate.method_7978(class_1893.field_9096, 1);
                    drowned.method_24523(chestplate);
                    drowned.method_5946(class_1304.field_6174, 0.2f);
                    class_1799 class_17992 = helmet = serverLevel.method_8409().method_43057() < 0.1f ? class_1802.field_8090.method_7854() : class_1802.field_8267.method_7854();
                    if (serverLevel.method_8409().method_43057() < 0.75f) {
                        helmet.method_7978(class_1893.field_9105, 1);
                    } else {
                        helmet.method_7978(class_1893.field_9127, 3);
                    }
                    drowned.method_24523(helmet);
                    drowned.method_5946(class_1304.field_6169, 0.15f);
                    if (isStrong) {
                        class_1799 trident = class_1802.field_8547.method_7854();
                        if ((double)serverLevel.method_8409().method_43057() < 0.25) {
                            trident.method_7978(class_1893.field_9117, 1);
                        } else if ((double)serverLevel.method_8409().method_43057() < 0.25) {
                            trident.method_7978(class_1893.field_9120, 1);
                        } else if ((double)serverLevel.method_8409().method_43057() < 0.25) {
                            trident.method_7978(class_1893.field_9106, 1);
                        } else {
                            trident.method_7978(class_1893.field_9104, 1);
                        }
                        drowned.method_5673(class_1304.field_6173, trident);
                        drowned.method_5946(class_1304.field_6173, 0.9f);
                    } else {
                        if (drowned.method_6047().method_31574(class_1802.field_8547)) {
                            drowned.method_5673(class_1304.field_6173, class_1799.field_8037);
                        } else if (drowned.method_6079().method_31574(class_1802.field_8547)) {
                            drowned.method_5673(class_1304.field_6171, class_1799.field_8037);
                        }
                        drowned.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 4, false, false, true));
                    }
                    if (drowned.method_6047().method_7960() && serverLevel.method_8409().method_43057() < 0.3f) {
                        drowned.method_5673(class_1304.field_6173, bonusItem);
                        drowned.method_5946(class_1304.field_6173, 2.0f);
                    } else if (drowned.method_6079().method_7960() && serverLevel.method_8409().method_43057() < 0.3f) {
                        drowned.method_5673(class_1304.field_6171, bonusItem);
                        drowned.method_5946(class_1304.field_6171, 2.0f);
                    }
                }
            }
        }
    }

    public void handleGiantBubbles(class_3218 serverLevel, class_2338 blockPos) {
        int bubbleMoveTime;
        if (!BzGeneralConfigs.blueArenaBubblesMechanic) {
            return;
        }
        long gameTime = serverLevel.method_8510();
        if (gameTime % (long)(bubbleMoveTime = 23) == 0L) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                int offSetBubble = direction.method_10166() == class_2350.class_2351.field_11048 ? 0 : 8;
                int currentProgress = (int)((gameTime / (long)bubbleMoveTime + (long)offSetBubble) % 16L);
                class_2338 bubbleCenter = blockPos.method_10069(direction.method_10148() * 10, currentProgress - 8, direction.method_10165() * 10);
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                for (int y = -2; y <= 1; ++y) {
                    mutableBlockPos.method_10101((class_2382)bubbleCenter).method_10104(class_2350.field_11036, y);
                    if (mutableBlockPos.method_10264() < blockPos.method_10264() - 5 || mutableBlockPos.method_10264() > blockPos.method_10264() + 5) continue;
                    for (int x = -1; x <= 1; ++x) {
                        mutableBlockPos.method_10104(class_2350.field_11034, x);
                        for (int z = -1; z <= 1; ++z) {
                            mutableBlockPos.method_10104(class_2350.field_11035, z);
                            if (y == -2) {
                                serverLevel.method_8652((class_2338)mutableBlockPos, class_2246.field_10382.method_9564(), 2);
                            } else {
                                serverLevel.method_8652((class_2338)mutableBlockPos, BzBlocks.DENSE_BUBBLE_BLOCK.get().method_9564(), 2);
                            }
                            mutableBlockPos.method_10104(class_2350.field_11035, -z);
                        }
                        mutableBlockPos.method_10104(class_2350.field_11034, -x);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.CALMING_EVENT.get().method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.CALMING_EVENT.get().method_14833(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

