/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.data.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wraith.alloyforgery.mixin.IngredientAccessor;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;
import wraith.alloyforgery.recipe.AlloyForgeRecipeSerializer;

public class AlloyForgeryRecipeBuilder
implements class_5797,
class_2444 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_707();
    private String group = "";
    private final class_1856 output;
    private final int outputCount;
    private final Map<class_1856, Integer> inputs = new LinkedHashMap<class_1856, Integer>();
    private final Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> ranges = new LinkedHashMap<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride>();
    private final Set<class_2960> priorities = new LinkedHashSet<class_2960>();
    private int minimumTier = 1;
    private int fuelPerTick = 5;
    @Nullable
    public class_2960 recipeId;
    @Nullable
    public class_2960 advancementId;

    public AlloyForgeryRecipeBuilder(class_1856 output, int outputCount) {
        this.output = output;
        this.outputCount = outputCount;
    }

    public static AlloyForgeryRecipeBuilder create(class_1935 output) {
        return AlloyForgeryRecipeBuilder.create(output, 1);
    }

    public static AlloyForgeryRecipeBuilder create(class_1935 output, int outputCount) {
        return new AlloyForgeryRecipeBuilder(class_1856.method_8091((class_1935[])new class_1935[]{output}), outputCount);
    }

    public static AlloyForgeryRecipeBuilder create(class_6862<class_1792> outputTag) {
        return AlloyForgeryRecipeBuilder.create(outputTag, 1);
    }

    public static AlloyForgeryRecipeBuilder create(class_6862<class_1792> outputTag, int outputCount) {
        return new AlloyForgeryRecipeBuilder(class_1856.method_8106(outputTag), outputCount);
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(class_1935 ... outputs) {
        return this.addPriorityOutput((class_2960[])Arrays.stream(outputs).map(output -> class_7923.field_41178.method_10221((Object)output.method_8389())).toArray(class_2960[]::new));
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(class_2960 ... outputId) {
        this.priorities.addAll(List.of(outputId));
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_6862<class_1792> input, int count) {
        this.inputs.put(class_1856.method_8106(input), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_1935 input, int count) {
        this.inputs.put(class_1856.method_8091((class_1935[])new class_1935[]{input}), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_1799 inputStack) {
        this.inputs.put(class_1856.method_8091((class_1935[])new class_1935[]{inputStack.method_7909()}), inputStack.method_7947());
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(AlloyForgeRecipe.OverrideRange range, AlloyForgeRecipe.PendingOverride override) {
        this.ranges.put(range, override);
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, int outputCount) {
        return this.overrideRange(start, end, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, @Nullable class_1935 output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(start, end), new AlloyForgeRecipe.PendingOverride(output != null ? output.method_8389().method_7854() : null, outputCount));
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, int outputCount) {
        return this.overrideRange(index, false, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, int outputCount) {
        return this.overrideRange(index, includeUpperValues, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, @Nullable class_1935 output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(index, includeUpperValues ? -1 : index), new AlloyForgeRecipe.PendingOverride(output != null ? output.method_8389().method_7854() : null, outputCount));
        return this;
    }

    public AlloyForgeryRecipeBuilder setMinimumForgeTier(int tier) {
        this.minimumTier = tier;
        return this;
    }

    public AlloyForgeryRecipeBuilder setFuelPerTick(int fuelAmount) {
        this.fuelPerTick = fuelAmount;
        return this;
    }

    public AlloyForgeryRecipeBuilder criterion(String string, class_184 criterionConditions) {
        this.advancementBuilder.method_709(string, criterionConditions);
        return this;
    }

    public AlloyForgeryRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return class_1802.field_8162;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate();
        this.advancementBuilder.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        this.recipeId = recipeId;
        this.advancementId = new class_2960(recipeId.method_12836(), "recipes/alloy_forgery/" + recipeId.method_12832());
        exporter.accept(this);
    }

    public void method_10431(Consumer<class_2444> exporter) {
        this.method_17972(exporter, this.makeRecipeId());
    }

    public void method_36443(Consumer<class_2444> exporter, String recipePath) {
        class_2960 identifier2 = new class_2960(recipePath);
        if (identifier2.equals((Object)this.makeRecipeId())) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.method_17972(exporter, identifier2);
    }

    public void validate() {
        if (this.advancementBuilder.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + this.recipeId);
        }
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Missing inputs meaning such cannot be made " + this.recipeId);
        }
    }

    private class_2960 makeRecipeId() {
        class_2960 outputId;
        class_1856.class_1859 firstEntry = ((IngredientAccessor)this.output).af$getEntries()[0];
        if (firstEntry instanceof class_1856.class_1858) {
            class_1856.class_1858 tagEntry = (class_1856.class_1858)firstEntry;
            outputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)tagEntry.method_8109(), (String)"tag"));
        } else if (firstEntry instanceof class_1856.class_1857) {
            class_1856.class_1857 stackEntry = (class_1856.class_1857)firstEntry;
            outputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)stackEntry.method_8109(), (String)"item"));
        } else {
            throw new IllegalStateException("Seems the output is composed of Ingredient Entry not implemented by Alloy Forgery, try manually naming your recipe instead");
        }
        return outputId;
    }

    public void method_10416(JsonObject recipeJson) {
        class_1856.class_1859 firstEntry;
        JsonArray array = new JsonArray();
        this.inputs.forEach((ingredient, integer) -> {
            class_1856.class_1859 firstEntry = ((IngredientAccessor)ingredient).af$getEntries()[0];
            JsonObject inputJson = new JsonObject();
            if (firstEntry instanceof class_1856.class_1858) {
                class_1856.class_1858 tagEntry = (class_1856.class_1858)firstEntry;
                class_2960 inputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)tagEntry.method_8109(), (String)"tag"));
                inputJson.addProperty("tag", inputId.toString());
            } else if (firstEntry instanceof class_1856.class_1857) {
                class_1856.class_1857 stackEntry = (class_1856.class_1857)firstEntry;
                class_2960 inputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)stackEntry.method_8109(), (String)"item"));
                inputJson.addProperty("item", inputId.toString());
            } else {
                throw new IllegalStateException("Seems the output is composed of Ingredient Entry not implemented by Alloy Forgery, try manually naming your recipe instead");
            }
            if (integer > 1) {
                inputJson.addProperty("count", (Number)integer);
            }
            array.add((JsonElement)inputJson);
        });
        recipeJson.add("inputs", (JsonElement)array);
        JsonObject outputJson = new JsonObject();
        JsonArray priorityArray = new JsonArray();
        if (!this.priorities.isEmpty()) {
            this.priorities.forEach(identifier -> priorityArray.add(identifier.toString()));
            outputJson.add("priority", (JsonElement)priorityArray);
        }
        if ((firstEntry = ((IngredientAccessor)this.output).af$getEntries()[0]) instanceof class_1856.class_1858) {
            class_1856.class_1858 tagEntry = (class_1856.class_1858)firstEntry;
            class_2960 outputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)tagEntry.method_8109(), (String)"tag"));
            outputJson.addProperty("default", outputId.toString());
            outputJson.add("priority", (JsonElement)priorityArray);
        } else if (firstEntry instanceof class_1856.class_1857) {
            class_1856.class_1857 stackEntry = (class_1856.class_1857)firstEntry;
            class_2960 outputId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)stackEntry.method_8109(), (String)"item"));
            outputJson.addProperty("id", outputId.toString());
            if (!priorityArray.isEmpty()) {
                LOGGER.warn("[AlloyForgeryRecipeBuilder] Priority-based recipes only work with Tag based Ingredient outputs, such will be ignored. [RecipeId: {}]", (Object)this.method_10417());
            }
        } else {
            throw new IllegalStateException("Seems the output is composed of Ingredient Entry not implemented by Alloy Forgery, try manually naming your recipe instead");
        }
        outputJson.addProperty("count", (Number)this.outputCount);
        recipeJson.add("output", (JsonElement)outputJson);
        if (!this.ranges.isEmpty()) {
            JsonObject overrideJson = new JsonObject();
            this.ranges.forEach((overrideRange, override) -> {
                JsonObject overrideObject = new JsonObject();
                if (!override.isCountOnly()) {
                    overrideObject.addProperty("id", class_7923.field_41178.method_10221((Object)override.stack().method_7909()).toString());
                }
                overrideObject.addProperty("count", (Number)override.count());
                overrideJson.add(overrideRange.toString(), (JsonElement)overrideObject);
            });
            recipeJson.add("overrides", (JsonElement)overrideJson);
        }
        recipeJson.addProperty("min_forge_tier", (Number)this.minimumTier);
        recipeJson.addProperty("fuel_per_tick", (Number)this.fuelPerTick);
    }

    public class_2960 method_10417() {
        return this.recipeId;
    }

    public class_1865<?> method_17800() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    @Nullable
    public JsonObject method_10415() {
        return this.advancementBuilder.method_698();
    }

    @Nullable
    public class_2960 method_10418() {
        return this.advancementId;
    }
}

