/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.api.client.effekseer;

import Effekseer.swig.EffekseerManagerCore;
import java.nio.FloatBuffer;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerEffect;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.client.effekseer.SafeFinalized;
import mod.chloeprime.aaaparticles.common.util.Helpers;
import org.joml.Matrix4f;

public class EffekseerManager
extends SafeFinalized<EffekseerManagerCore> {
    private static final ThreadLocal<float[]> MATRIX_BUFFER = ThreadLocal.withInitial(() -> new float[16]);
    private final EffekseerManagerCore impl;

    public EffekseerManager() {
        this(Helpers.checkPlatform(EffekseerManagerCore::new));
    }

    public boolean init(int maxSprites, boolean srgb) {
        return this.impl.Initialize(maxSprites, srgb);
    }

    public boolean init(int maxSprites) {
        return this.impl.Initialize(maxSprites);
    }

    public void update(float delta) {
        this.impl.Update(delta);
    }

    public void startUpdate() {
        this.impl.BeginUpdate();
    }

    public void endUpdate() {
        this.impl.EndUpdate();
    }

    @Override
    public void close() {
        this.impl.delete();
    }

    public ParticleEmitter createParticle(EffekseerEffect effect) {
        return this.createParticle(effect, ParticleEmitter.Type.WORLD);
    }

    public ParticleEmitter createParticle(EffekseerEffect effect, ParticleEmitter.Type type) {
        int handle = this.impl.Play(effect.getImpl());
        return new ParticleEmitter(handle, this, type);
    }

    public void stopAllEffects() {
        this.impl.StopAllEffects();
    }

    public void draw() {
        this.drawBack();
        this.drawFront();
    }

    public void drawBack() {
        this.impl.DrawBack();
    }

    public void drawFront() {
        this.impl.DrawFront();
    }

    public void setViewport(int width, int height) {
        this.impl.SetViewProjectionMatrixWithSimpleWindow(width, height);
    }

    public void setupWorkerThreads(int count) {
        this.impl.LaunchWorkerThreads(count);
    }

    public void setCameraMatrix(float[] m) {
        this.impl.SetCameraMatrix(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14], m[15]);
    }

    public void setCameraMatrix(Matrix4f m) {
        FloatBuffer buffer = FloatBuffer.wrap(MATRIX_BUFFER.get());
        m.get(buffer);
        this.setCameraMatrix(buffer);
    }

    public void setCameraMatrix(FloatBuffer buf) {
        this.impl.SetCameraMatrix(buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get());
    }

    public void setCameraParameter(float frontX, float frontY, float frontZ, float posX, float posY, float posZ) {
        this.impl.SetCameraParameter(frontX, frontY, frontZ, posX, posY, posZ);
    }

    public void setProjectionMatrix(Matrix4f m) {
        FloatBuffer buffer = FloatBuffer.wrap(MATRIX_BUFFER.get());
        m.get(buffer);
        this.setProjectionMatrix(buffer);
    }

    public void setProjectionMatrix(FloatBuffer buf) {
        this.impl.SetProjectionMatrix(buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get(), buf.get());
    }

    public void setProjectionMatrix(float[] m) {
        this.impl.SetProjectionMatrix(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14], m[15]);
    }

    public final EffekseerManagerCore getImpl() {
        return this.impl;
    }

    protected EffekseerManager(EffekseerManagerCore impl) {
        super(impl, EffekseerManagerCore::delete);
        this.impl = impl;
    }
}

