/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveItemModificationConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public abstract class CompatComponent<T> {
    protected T inventory;

    public CompatComponent(class_3222 player) {
        this.inventory = this.getInventory(player);
    }

    public CompatComponent(T inventory) {
        this.inventory = inventory;
    }

    public abstract T getInventory(class_3222 var1);

    public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
        return class_2371.method_10211();
    }

    public abstract class_2371<GraveItem> merge(CompatComponent<?> var1, class_3222 var2);

    public abstract class_2371<class_1799> storeToPlayer(class_3222 var1);

    public abstract void handleDropRules(DeathContext var1);

    public abstract class_2371<GraveItem> getAsGraveItemList();

    public abstract CompatComponent<T> filterInv(Predicate<DropRule> var1);

    public abstract boolean removeItem(Predicate<class_1799> var1, int var2);

    public void dropItems(class_3218 world, class_243 pos) {
        class_2371<GraveItem> items = this.getAsGraveItemList();
        for (GraveItem graveItem : items) {
            class_1799 stack = graveItem.stack;
            if (stack.method_7960()) continue;
            InventoryComponent.dropItemIfToBeDropped(graveItem.stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
    }

    public void dropGraveItems(class_3218 world, class_243 pos) {
        class_2371<GraveItem> items = this.getAsGraveItemList();
        for (GraveItem graveItem : items) {
            class_1799 stack = graveItem.stack;
            if (stack.method_7960() || graveItem.dropRule == DropRule.KEEP || graveItem.dropRule == DropRule.DESTROY) continue;
            graveItem.dropRule = DropRule.DROP;
            InventoryComponent.dropItemIfToBeDropped(graveItem.stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
    }

    public abstract void clear();

    public boolean containsGraveItems() {
        for (GraveItem graveItem : this.getAsGraveItemList()) {
            if (graveItem.stack.method_7960() || graveItem.dropRule != DropRule.PUT_IN_GRAVE) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.containsAny(stack -> !stack.method_7960());
    }

    public boolean containsAny(Predicate<class_1799> predicate) {
        for (GraveItem graveItem : this.getAsGraveItemList()) {
            if (!predicate.test(graveItem.stack)) continue;
            return true;
        }
        return false;
    }

    public void handleGraveItems(GraveItemModificationConsumer modification) {
        for (GraveItem graveItem : this.getAsGraveItemList()) {
            modification.accept(graveItem.stack, -1, graveItem);
        }
    }

    public abstract class_2487 writeNbt();
}

