/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.beansgalaxy.backpacks.platform.FabricCompatHelper;
import com.beansgalaxy.backpacks.platform.services.CompatHelper;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BeansBackpacksCompat
implements InvModCompat<BeansBackpackInv> {
    public BeansBackpacksCompat() {
        FabricCompatHelper.OnDeathCallback.EVENT.register(FabricCompatHelper.Context::cancel);
    }

    public static void prepForTrinkets() {
        FabricCompatHelper.OnDeathCallback.EVENT.register(FabricCompatHelper.Context::cancel);
    }

    @Override
    public String getModName() {
        return "beansbackpacks";
    }

    @Override
    public void clear(class_3222 player) {
        CompatHelper.setBackStack((class_1657)player, (class_1799)class_1799.field_8037);
        CompatHelper.getBackpackInventory((class_1657)player).clear();
    }

    @Override
    public CompatComponent<BeansBackpackInv> readNbt(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt.method_10562("stack"));
        DropRule rule = DropRule.valueOf(nbt.method_10558("dropRule"));
        class_2487 backpackContentsNbt = nbt.method_10562("backpackContents");
        UUID ownerId = nbt.method_25926("ownerId");
        float yaw = nbt.method_10583("yaw");
        class_2350 direction = class_2350.method_10143((int)nbt.method_10550("direction"));
        class_2371<class_1799> backpackContents = InventoryComponent.listFromNbt(backpackContentsNbt, class_1799::method_7915, class_1799.field_8037);
        BeansBackpackInv inv = new BeansBackpackInv(stack, rule, backpackContents, ownerId, yaw, direction);
        return new BeansBackpacksComponent(inv);
    }

    @Override
    public CompatComponent<BeansBackpackInv> getNewComponent(class_3222 player) {
        return new BeansBackpacksComponent(player);
    }

    public static class BeansBackpackInv {
        private class_1799 stack;
        private DropRule dropRule;
        private class_2371<class_1799> backpackContents;
        private final UUID ownerId;
        private final float yaw;
        private final class_2350 direction;

        public BeansBackpackInv(class_1799 stack, DropRule dropRule, class_2371<class_1799> backpackContents, UUID ownerId, float yaw, class_2350 direction) {
            this.stack = stack;
            this.dropRule = dropRule;
            this.backpackContents = backpackContents;
            this.ownerId = ownerId;
            this.yaw = yaw;
            this.direction = direction;
        }

        public class_1799 getBackpack() {
            return this.stack;
        }

        public DropRule getDropRule() {
            return this.dropRule;
        }

        public class_2371<class_1799> getBackpackContents() {
            return this.backpackContents;
        }

        public void setBackpack(class_1799 stack) {
            this.stack = stack;
        }

        public void setDropRule(DropRule dropRule) {
            this.dropRule = dropRule;
        }

        public void setBackpackContents(class_2371<class_1799> backpackContents) {
            this.backpackContents = backpackContents;
        }
    }

    private static class BeansBackpacksComponent
    extends CompatComponent<BeansBackpackInv> {
        public BeansBackpacksComponent(class_3222 player) {
            super(player);
        }

        public BeansBackpacksComponent(BeansBackpackInv inventory) {
            super(inventory);
        }

        @Override
        public BeansBackpackInv getInventory(class_3222 player) {
            class_1799 stack = CompatHelper.getBackStack((class_1657)player).method_7972();
            class_2371 backpackContents = CompatHelper.getBackpackInventory((class_1657)player);
            class_2371 copied = class_2371.method_10211();
            for (class_1799 i : backpackContents) {
                copied.add((Object)i.method_7972());
            }
            return new BeansBackpackInv(stack, DropRule.PUT_IN_GRAVE, (class_2371<class_1799>)copied, player.method_5667(), player.field_6241, player.method_5735());
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            class_1799 backpack = ((BeansBackpackInv)this.inventory).getBackpack().method_7972();
            class_2371<class_1799> backpackContents = ((BeansBackpackInv)this.inventory).getBackpackContents();
            if (backpack.method_7960()) {
                for (class_1799 extra : backpackContents) {
                    if (extra.method_7960()) continue;
                    extraItems.add((Object)extra.method_7972());
                }
                return extraItems;
            }
            CompatHelper.setBackStack((class_1657)player, (class_1799)backpack);
            class_2371 backpackInventory = CompatHelper.getBackpackInventory((class_1657)player);
            backpackInventory.clear();
            for (class_1799 stack : backpackContents) {
                if (stack.method_7960()) continue;
                backpackInventory.add((Object)stack.method_7972());
            }
            CompatHelper.updateBackpackInventory2C((class_3222)player);
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            DropRule defaultDropRule = compatConfig.defaultBeansBackpacksDropRule;
            if (((BeansBackpackInv)this.inventory).getBackpack().method_7960()) {
                ((BeansBackpackInv)this.inventory).setDropRule(defaultDropRule);
                return;
            }
            if (defaultDropRule == DropRule.PUT_IN_GRAVE) {
                ((BeansBackpackInv)this.inventory).setDropRule(((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(((BeansBackpackInv)this.inventory).getBackpack(), -1, context, true));
            }
        }

        @Override
        public class_2371<GraveItem> getAsGraveItemList() {
            DropRule dropRule = ((BeansBackpackInv)this.inventory).getDropRule();
            class_2371 stacks = class_2371.method_10211();
            stacks.add((Object)new GraveItem(((BeansBackpackInv)this.inventory).getBackpack(), dropRule));
            for (class_1799 stack : ((BeansBackpackInv)this.inventory).getBackpackContents()) {
                stacks.add((Object)new GraveItem(stack, dropRule));
            }
            return stacks;
        }

        @Override
        public void clear() {
            ((BeansBackpackInv)this.inventory).setBackpack(class_1799.field_8037);
            ((BeansBackpackInv)this.inventory).getBackpackContents().clear();
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("stack", (class_2520)((BeansBackpackInv)this.inventory).stack.method_7953(new class_2487()));
            nbt.method_10582("dropRule", ((BeansBackpackInv)this.inventory).dropRule.name());
            nbt.method_25927("ownerId", ((BeansBackpackInv)this.inventory).ownerId);
            nbt.method_10548("yaw", ((BeansBackpackInv)this.inventory).yaw);
            nbt.method_10569("direction", ((BeansBackpackInv)this.inventory).direction.method_10146());
            class_2487 backpackContentsNbt = InventoryComponent.listToNbt(((BeansBackpackInv)this.inventory).getBackpackContents(), itemStack -> itemStack.method_7953(new class_2487()), class_1799::method_7960);
            nbt.method_10566("backpackContents", (class_2520)backpackContentsNbt);
            return nbt;
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (class_1799 stack : ((BeansBackpackInv)this.inventory).getBackpackContents()) {
                if (!predicate.test(stack)) continue;
                stack.method_7934(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void dropItems(class_3218 world, class_243 pos) {
            CompatHelper.createBackpackEntity((class_1799)((BeansBackpackInv)this.inventory).getBackpack(), (int)((int)pos.field_1352), (double)((int)pos.field_1351), (int)((int)pos.field_1350), (float)((BeansBackpackInv)this.inventory).yaw, (boolean)true, (class_2350)((BeansBackpackInv)this.inventory).direction, (class_1937)world, (UUID)((BeansBackpackInv)this.inventory).ownerId, ((BeansBackpackInv)this.inventory).getBackpackContents());
        }

        @Override
        public void dropGraveItems(class_3218 world, class_243 pos) {
            if (((BeansBackpackInv)this.inventory).getDropRule() == DropRule.KEEP || ((BeansBackpackInv)this.inventory).getDropRule() == DropRule.DESTROY) {
                return;
            }
            ((BeansBackpackInv)this.inventory).setDropRule(DropRule.DROP);
            CompatHelper.createBackpackEntity((class_1799)((BeansBackpackInv)this.inventory).getBackpack(), (int)((int)pos.field_1352), (double)((int)pos.field_1351), (int)((int)pos.field_1350), (float)((BeansBackpackInv)this.inventory).yaw, (boolean)true, (class_2350)((BeansBackpackInv)this.inventory).direction, (class_1937)world, (UUID)((BeansBackpackInv)this.inventory).ownerId, ((BeansBackpackInv)this.inventory).getBackpackContents());
        }

        @Override
        public CompatComponent<BeansBackpackInv> filterInv(Predicate<DropRule> predicate) {
            if (predicate.test(((BeansBackpackInv)this.inventory).getDropRule())) {
                return new BeansBackpacksComponent((BeansBackpackInv)this.inventory);
            }
            return new BeansBackpacksComponent(new BeansBackpackInv(class_1799.field_8037, DropRule.PUT_IN_GRAVE, (class_2371<class_1799>)class_2371.method_10211(), ((BeansBackpackInv)this.inventory).ownerId, ((BeansBackpackInv)this.inventory).yaw, ((BeansBackpackInv)this.inventory).direction));
        }

        @Override
        public class_2371<GraveItem> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            BeansBackpackInv mergingInventory = (BeansBackpackInv)mergingComponent.inventory;
            if (((BeansBackpackInv)this.inventory).getBackpack().method_7960()) {
                for (class_1799 withoutBackpack : ((BeansBackpackInv)this.inventory).getBackpackContents()) {
                    if (withoutBackpack.method_7960()) continue;
                    extraItems.add((Object)new GraveItem(withoutBackpack, ((BeansBackpackInv)this.inventory).getDropRule()));
                }
                ((BeansBackpackInv)this.inventory).setBackpack(mergingInventory.getBackpack());
                ((BeansBackpackInv)this.inventory).setDropRule(mergingInventory.getDropRule());
                ((BeansBackpackInv)this.inventory).setBackpackContents(mergingInventory.getBackpackContents());
            } else {
                extraItems.add((Object)new GraveItem(mergingInventory.getBackpack(), mergingInventory.getDropRule()));
                for (class_1799 stack : mergingInventory.getBackpackContents()) {
                    if (stack.method_7960()) continue;
                    extraItems.add((Object)new GraveItem(stack, mergingInventory.getDropRule()));
                }
            }
            return extraItems;
        }
    }
}

