/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin;

import com.bawnorton.bettertrims.config.ConfigManager;
import com.bawnorton.bettertrims.effect.ArmorTrimEffects;
import com.bawnorton.bettertrims.mixin.LivingEntityMixin;
import com.bawnorton.bettertrims.util.NumberWrapper;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    @ModifyVariable(method={"addExperience"}, at=@At(value="HEAD"), argsOnly=true)
    private int applyTrimExperienceIncrease(int experience) {
        if (experience <= 0) {
            return experience;
        }
        NumberWrapper increase = NumberWrapper.one();
        ArmorTrimEffects.QUARTZ.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().quartzExperienceBonus));
        return (int)((float)experience * increase.getFloat());
    }

    @ModifyReturnValue(method={"getMovementSpeed"}, at={@At(value="RETURN")})
    private float applyTrimSpeedIncrease(float original) {
        NumberWrapper increase = NumberWrapper.one();
        ArmorTrimEffects.REDSTONE.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().redstoneMovementSpeedIncrease));
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.movementSpeed));
        }
        return original * increase.getFloat();
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private float applyTrimDamageIncrease(float original) {
        NumberWrapper increase = NumberWrapper.of(Float.valueOf(original));
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.attackDamage));
        }
        return increase.getFloat();
    }

    @ModifyExpressionValue(method={"getAttackCooldownProgressPerTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D")})
    private double applyTrimAttackSpeedIncrease(double original) {
        NumberWrapper increase = NumberWrapper.of(original);
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.attackSpeed));
        }
        return increase.getFloat();
    }

    @ModifyExpressionValue(method={"method_30263"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getStepHeight()F")})
    private float adjustStepHeightForSneaking(float original) {
        NumberWrapper decrease = NumberWrapper.zero();
        ArmorTrimEffects.LEATHER.apply(this.betterTrims$getTrimmables(), () -> decrease.increment(ConfigManager.getConfig().leatherStepHeightIncrease));
        return original - decrease.getFloat();
    }
}

