/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.impl;

import com.bawnorton.bettertrims.client.config.ClientConfigManager;
import com.bawnorton.bettertrims.client.networking.ClientNetworking;
import com.bawnorton.bettertrims.config.ConfigManager;
import com.bawnorton.bettertrims.config.annotation.Groups;
import com.bawnorton.bettertrims.config.option.ConfigOptionReference;
import com.bawnorton.bettertrims.config.option.ParentedConfigOptionReference;
import com.bawnorton.bettertrims.reflection.Reflection;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public abstract class YACLImpl {
    private static boolean inScreen = false;
    private static class_437 screenParent = null;

    public static class_437 getScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder().title((class_2561)YACLImpl.yaclText("title", "main")).categories(YACLImpl.generateCategories()).save(() -> {
            boolean inWorld;
            boolean bl = inWorld = class_310.method_1551().field_1687 != null;
            if (inWorld && ClientNetworking.isConnectedToDedicated()) {
                ClientNetworking.trySendConfigToServer();
                return;
            }
            inScreen = false;
            ConfigManager.saveLocalConfig();
        }).screenInit(yaclScreen -> {
            inScreen = true;
            screenParent = parent;
        }).build().generateScreen(parent);
    }

    public static void refreshScreen() {
        if (!inScreen) {
            return;
        }
        class_310.method_1551().method_1507(YACLImpl.getScreen(screenParent));
    }

    private static Collection<ConfigCategory> generateCategories() {
        ArrayList<ConfigCategory> categories = new ArrayList<ConfigCategory>();
        Groups groups = Reflection.getAnnotation(ClientConfigManager.getConfig(), Groups.class);
        ArrayList<String> groupNames = new ArrayList<String>(Arrays.asList(groups.value()));
        Reflection.forEachAnnotatedField(ClientConfigManager.getConfig(), field -> ConfigOptionReference.readGroup(field).ifPresent(group -> {
            if (!groupNames.contains(group)) {
                throw new IllegalStateException("Group \"" + group + "\" does not exist. It is referenced by field \"" + field.getName() + "\".");
            }
        }));
        for (String group : groupNames) {
            categories.add(YACLImpl.generateCategoryForGroup(group));
        }
        return categories;
    }

    private static ConfigCategory generateCategoryForGroup(String group) {
        return ConfigCategory.createBuilder().name((class_2561)YACLImpl.category(group)).tooltip(new class_2561[]{YACLImpl.tooltip(group)}).group(OptionGroup.createBuilder().name((class_2561)YACLImpl.group(group)).description(OptionDescription.of((class_2561[])new class_2561[]{YACLImpl.description(group)})).options(YACLImpl.generateOptionsForGroup(group)).build()).build();
    }

    private static Collection<? extends Option<?>> generateOptionsForGroup(String group) {
        HashSet options = new HashSet();
        Reflection.forEachAnnotatedField(ClientConfigManager.getConfig(), field -> {
            ConfigOptionReference reference = ConfigOptionReference.of(ClientConfigManager.getConfig(), field);
            if (!reference.isOf(group)) {
                return;
            }
            if (reference.isNested()) {
                options.addAll(YACLImpl.createNestedOptions(reference, group));
            } else {
                options.add(YACLImpl.createOption(reference));
            }
        });
        return options.stream().sorted(Comparator.comparing(option -> option.name().getString())).toList();
    }

    private static Collection<? extends Option<?>> createNestedOptions(ConfigOptionReference reference, String type) {
        if (!reference.isNested()) {
            throw new IllegalArgumentException("Reference \"%s\" is not nested".formatted(reference.getFormattedName()));
        }
        ArrayList options = new ArrayList();
        Object instance = reference.nestedValue();
        Reflection.forEachAnnotatedField(instance, nestedField -> {
            ParentedConfigOptionReference parentedReference = ParentedConfigOptionReference.of(reference, instance, nestedField);
            if (!parentedReference.isOf(type)) {
                return;
            }
            if (parentedReference.isNested()) {
                options.addAll(YACLImpl.createNestedOptions(parentedReference, type));
            } else {
                options.add(YACLImpl.createOption(parentedReference));
            }
        });
        return options;
    }

    private static Option<?> createOption(ConfigOptionReference reference) {
        return switch (reference.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigOptionReference.FieldType.BOOLEAN -> YACLImpl.booleanOption(reference);
            case ConfigOptionReference.FieldType.INTEGER -> YACLImpl.integerOption(reference);
            case ConfigOptionReference.FieldType.FLOAT -> YACLImpl.floatOption(reference);
            case ConfigOptionReference.FieldType.NESTED -> throw new IllegalArgumentException("Attempted to of non-nested option for nested reference \"%s\"".formatted(reference.getFormattedName()));
        };
    }

    private static Option<Float> floatOption(ConfigOptionReference reference) {
        return Option.createBuilder().name((class_2561)YACLImpl.option(reference.getFormattedName())).description(YACLImpl.imagedDescription(reference)).binding(Binding.generic((Object)reference.floatValue(), reference::floatValue, reference::floatValue)).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).formatValue(value -> class_2561.method_43470((String)String.format("%,.2f", value).replaceAll("[\u00a0\u202f]", " ")))).range((Number)reference.minFloatValue(), (Number)reference.maxFloatValue())).step((Number)Float.valueOf(reference.maxFloatValue().floatValue() / 100.0f))).build();
    }

    private static Option<Boolean> booleanOption(ConfigOptionReference reference) {
        return Option.createBuilder().name((class_2561)YACLImpl.option(reference.getFormattedName())).description(YACLImpl.imagedDescription(reference)).binding(Binding.generic((Object)reference.booleanValue(), reference::booleanValue, reference::booleanValue)).controller(TickBoxControllerBuilder::create).build();
    }

    private static Option<Integer> integerOption(ConfigOptionReference reference) {
        return Option.createBuilder().name((class_2561)YACLImpl.option(reference.getFormattedName())).description(YACLImpl.imagedDescription(reference)).binding(Binding.generic((Object)reference.intValue(), reference::intValue, reference::intValue)).controller(option -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)reference.minIntValue(), (Number)reference.maxIntValue())).step((Number)Math.max(1, reference.maxIntValue() / 100))).build();
    }

    private static OptionDescription imagedDescription(ConfigOptionReference reference) {
        class_2960 textureLocation = reference.findTexture();
        if (textureLocation == null || class_310.method_1551().method_1478().method_14486(textureLocation).isEmpty()) {
            return OptionDescription.of((class_2561[])new class_2561[]{YACLImpl.description(reference.getFormattedName())});
        }
        return OptionDescription.createBuilder().image(textureLocation, 16, 16).text(new class_2561[]{YACLImpl.description(reference.getFormattedName())}).build();
    }

    private static class_5250 category(String key) {
        return YACLImpl.yaclText("category", key);
    }

    private static class_5250 tooltip(String key) {
        return YACLImpl.yaclText("tooltip", key);
    }

    private static class_5250 group(String key) {
        return YACLImpl.yaclText("group", key);
    }

    private static class_5250 description(String key) {
        return YACLImpl.yaclText("description", key);
    }

    private static class_5250 option(String key) {
        return YACLImpl.yaclText("option", key);
    }

    private static class_5250 yaclText(String category, String key) {
        return class_2561.method_43471((String)"bettertrims.yacl.%s.%s".formatted(category, key));
    }
}

