/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.util.Utils;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;

public class DebugRendererExtensions {
    private static final Set<Renderers> EMPTY = ImmutableSet.of();

    @Environment(value=EnvType.CLIENT)
    public static Set<Renderers> getEnabledRenderers() {
        if (!Utils.isDevEnv()) {
            return EMPTY;
        }
        return ImmutableSet.of();
    }

    @Environment(value=EnvType.CLIENT)
    public static void render(class_4587 poseStack, class_4597.class_4598 bufferSource, double camX, double camY, double camZ) {
        for (Renderers renderer : DebugRendererExtensions.getEnabledRenderers()) {
            renderer.getRenderer().method_23109(poseStack, (class_4597)bufferSource, camX, camY, camZ);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Renderers {
        PATHFINDING(d -> d.field_4523),
        WATER(d -> d.field_4528),
        HEIGHT_MAP(d -> d.field_4538),
        COLLISION_BOX(d -> d.field_4534),
        NEIGHBORS_UPDATE(d -> d.field_4535),
        STRUCTURE(d -> d.field_4539),
        LIGHT(d -> d.field_4536),
        WORLD_GEN_ATTEMPT(d -> d.field_4537),
        SOLID_FACE(d -> d.field_4517),
        CHUNK(d -> d.field_4533),
        BRAIN(d -> d.field_18777),
        VILLAGE_SECTIONS(d -> d.field_22408),
        BEE(d -> d.field_21547),
        RAID(d -> d.field_19325),
        GOAL_SELECTOR(g -> g.field_18778),
        GAME_TEST(g -> g.field_20519),
        GAME_EVENT(g -> g.field_28254);

        private final Function<class_863, class_863.class_864> rendererSupplier;

        private Renderers(Function<class_863, class_863.class_864> rendererSupplier) {
            this.rendererSupplier = rendererSupplier;
        }

        public class_863.class_864 getRenderer() {
            return this.rendererSupplier.apply(class_310.method_1551().field_1709);
        }
    }
}

