/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.items.misc.WrappedGenericStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerPattern
extends class_1703 {
    protected final class_1799 stack;
    protected final IPatternDetails details;
    protected final List<GenericStack[]> inputs = new ArrayList<GenericStack[]>();
    protected final List<GenericStack[]> outputs = new ArrayList<GenericStack[]>();
    private boolean valid = true;
    private int cycle = 0;

    public ContainerPattern(@Nullable class_3917<?> menuType, class_1937 world, int id, class_1799 stack) {
        super(menuType, id);
        this.stack = stack;
        class_1792 item = this.stack.method_7909();
        if (!(item instanceof EncodedPatternItem)) {
            throw new IllegalArgumentException(String.format("%s isn't an encoded pattern!", item));
        }
        EncodedPatternItem pattern = (EncodedPatternItem)item;
        this.details = pattern.decode(stack, world, true);
        this.analyse();
    }

    protected abstract void analyse();

    public void invalidate() {
        this.valid = false;
    }

    public void setCycleItem(int index) {
        this.cycle = index;
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int idx) {
        return class_1799.field_8037;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.details != null && this.valid;
    }

    protected GenericStack[] clean(GenericStack[] in) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        set.addAll(Arrays.asList(in));
        GenericStack[] c = new GenericStack[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            GenericStack tmp;
            c[i] = tmp = (GenericStack)iterator.next();
            ++i;
        }
        return c;
    }

    public static class DisplayOnlySlot
    extends class_1735 {
        private static final class_1263 EMPTY_INVENTORY = new class_1277(0);
        private final class_1799[] displays;
        private final ContainerPattern container;
        private long size = 0L;

        public DisplayOnlySlot(ContainerPattern container, List<GenericStack[]> stacks, int index, int x, int y) {
            super(EMPTY_INVENTORY, index, x, y);
            if (index >= stacks.size()) {
                this.displays = new class_1799[0];
            } else {
                GenericStack[] genStack = stacks.get(index);
                this.displays = new class_1799[genStack.length];
                if (genStack.length > 0) {
                    for (int i = 0; i < genStack.length; ++i) {
                        this.displays[i] = this.getAsItem(genStack[i]);
                    }
                }
            }
            this.container = container;
        }

        public boolean method_7680(@NotNull class_1799 stack) {
            return false;
        }

        public boolean method_7674(@NotNull class_1657 player) {
            return false;
        }

        @NotNull
        public class_1799 method_7677() {
            return this.getItem(this.container.cycle);
        }

        public void method_7673(@NotNull class_1799 stack) {
        }

        public class_1799 method_7671(int amount) {
            return class_1799.field_8037;
        }

        @NotNull
        public class_1799 getItem(int rowIndex) {
            if (this.displays.length > 0) {
                return this.displays[rowIndex %= this.displays.length];
            }
            return class_1799.field_8037;
        }

        public long getActualAmount() {
            return this.size;
        }

        public boolean shouldUseMEText() {
            return !(this.method_7677().method_7909() instanceof WrappedGenericStack);
        }

        @NotNull
        private class_1799 getAsItem(GenericStack stack) {
            AEKey aEKey;
            if (stack != null && (aEKey = stack.what()) instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                this.size = stack.amount();
                return itemKey.toStack();
            }
            return GenericStack.wrapInItemStack((GenericStack)stack);
        }
    }
}

