/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.client.Point;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.IOptionalSlot;
import appeng.menu.slot.OutputSlot;
import com.github.glodblock.extendedae.api.IPage;
import com.github.glodblock.extendedae.client.ExSemantics;
import com.github.glodblock.extendedae.common.tileentities.TileExMolecularAssembler;
import com.github.glodblock.extendedae.network.packet.sync.IActionHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class ContainerExMolecularAssembler
extends UpgradeableMenu<TileExMolecularAssembler>
implements IProgressProvider,
IPage,
IActionHolder {
    public static final class_3917<ContainerExMolecularAssembler> TYPE = MenuTypeBuilder.create(ContainerExMolecularAssembler::new, TileExMolecularAssembler.class).build("ex_molecular_assembler");
    private static final int MAX_CRAFT_PROGRESS = 100;
    private final Map<String, Consumer<Object[]>> actions = new Object2ObjectOpenHashMap();
    private static final SlotSemantic[] SLOT = new SlotSemantic[]{ExSemantics.EX_1, ExSemantics.EX_2, ExSemantics.EX_3, ExSemantics.EX_4, ExSemantics.EX_5, ExSemantics.EX_6, ExSemantics.EX_7, ExSemantics.EX_8};
    private final TileExMolecularAssembler molecularAssembler;
    private final List<AppEngSlot> outputs = new ArrayList<AppEngSlot>();
    @GuiSync(value=4)
    public int craftProgress = 0;
    @GuiSync(value=7)
    public int page = 0;

    public ContainerExMolecularAssembler(int id, class_1661 ip, TileExMolecularAssembler host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("show", o -> this.showPage());
        this.molecularAssembler = host;
        for (int i = 0; i < 8; ++i) {
            InternalInventory inv = this.molecularAssembler.getCraftInventory(i);
            for (int j = 0; j < 9; ++j) {
                this.addSlot((class_1735)new ExMolecularAssemblerPatternSlot(this, inv, j), SLOT[i]);
            }
            this.outputs.add((AppEngSlot)this.addSlot((class_1735)new OutputSlot(inv, 9, null), SlotSemantics.MACHINE_OUTPUT));
        }
    }

    public void showPage() {
        for (int x = 0; x < 8; ++x) {
            for (class_1735 slot : this.getSlots(SLOT[x])) {
                if (!(slot instanceof AppEngSlot)) continue;
                AppEngSlot as = (AppEngSlot)slot;
                as.setSlotEnabled(this.page == x);
            }
            this.outputs.get(x).setSlotEnabled(this.page == x);
        }
    }

    public boolean isValidItemForSlot(int slotIndex, class_1799 i) {
        IMolecularAssemblerSupportedPattern details = this.molecularAssembler.getCurrentPattern(this.page);
        if (details != null) {
            return details.isItemValid(slotIndex, AEItemKey.of((class_1799)i), this.molecularAssembler.method_10997());
        }
        return false;
    }

    public void method_7623() {
        this.craftProgress = this.molecularAssembler.getCraftingProgress(this.page);
        this.standardDetectAndSendChanges();
    }

    public int getCurrentProgress() {
        return this.craftProgress;
    }

    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    @NotNull
    public Map<String, Consumer<Object[]>> getActionMap() {
        return this.actions;
    }

    public static class ExMolecularAssemblerPatternSlot
    extends AppEngSlot
    implements IOptionalSlot {
        private final ContainerExMolecularAssembler mac;

        public ExMolecularAssemblerPatternSlot(ContainerExMolecularAssembler mac, InternalInventory inv, int invSlot) {
            super(inv, invSlot);
            this.mac = mac;
        }

        public boolean method_7680(class_1799 stack) {
            return super.method_7680(stack) && this.mac.isValidItemForSlot(this.method_34266(), stack);
        }

        protected boolean getCurrentValidationState() {
            class_1799 stack = this.method_7677();
            return stack.method_7960() || this.method_7680(stack);
        }

        public boolean isRenderDisabled() {
            return true;
        }

        public boolean isSlotEnabled() {
            if (!this.getInventory().getStackInSlot(this.method_34266()).method_7960()) {
                return true;
            }
            IMolecularAssemblerSupportedPattern pattern = ((TileExMolecularAssembler)this.mac.getHost()).getCurrentPattern(this.mac.page);
            return this.method_34266() >= 0 && this.method_34266() < 9 && pattern != null && pattern.isSlotEnabled(this.method_34266());
        }

        public Point getBackgroundPos() {
            return new Point(this.field_7873 - 1, this.field_7872 - 1);
        }
    }
}

