/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEItems;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.common.me.FreqGenerator;
import com.github.glodblock.extendedae.common.me.wireless.WirelessConnect;
import com.github.glodblock.extendedae.util.CacheHolder;
import com.github.glodblock.extendedae.util.FCUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class TileWirelessConnector
extends AENetworkBlockEntity
implements ServerTickingBlockEntity,
IUpgradeableObject,
IColorableBlockEntity {
    private boolean updateStatus = true;
    private long freq = 0L;
    private final WirelessConnect connect;
    private double powerUse;
    private final IUpgradeInventory upgrades;
    private final CacheHolder<class_2338> other = CacheHolder.empty();
    private static final FreqGenerator<Long> G = FreqGenerator.createLong();
    @NotNull
    private AEColor color = AEColor.TRANSPARENT;

    public TileWirelessConnector(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileWirelessConnector.class, TileWirelessConnector::new, (class_2248)EAEItemAndBlock.WIRELESS_CONNECTOR), pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        this.powerUse = 1.0;
        this.getMainNode().setIdlePowerUsage(this.powerUse);
        this.connect = new WirelessConnect(this);
        this.upgrades = UpgradeInventories.forMachine((class_1935)EAEItemAndBlock.WIRELESS_CONNECTOR, (int)4, this::updatePowerUsage);
    }

    public void serverTick() {
        if (this.updateStatus) {
            this.updateStatus = false;
            this.other.expired();
            this.connect.updateStatus();
            this.updatePowerUsage();
            this.markForUpdate();
            this.reactive();
        }
    }

    public void updatePowerUsage() {
        double disc = 1.0 - 0.1 * (double)this.upgrades.getInstalledUpgrades((class_1935)AEItems.ENERGY_CARD);
        if (this.connect.isConnected()) {
            double dis = Math.max(this.connect.getDistance(), Math.E);
            this.powerUse = Math.max(1.0, dis * Math.log(dis) * disc);
        } else {
            this.powerUse = 1.0;
        }
        this.getMainNode().setIdlePowerUsage(this.powerUse);
    }

    public double getPowerUse() {
        return this.powerUse;
    }

    public class_2338 getOtherSide() {
        if (this.connect.isConnected()) {
            if (!this.other.isValid()) {
                this.other.update(this.connect.getOtherSide());
            }
            return this.other.get();
        }
        return null;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateStatus = true;
    }

    public void reactive() {
        this.connect.active();
    }

    public void onChunkUnloaded() {
        this.disconnect();
        super.onChunkUnloaded();
    }

    public void onReady() {
        super.onReady();
        this.updateStatus = true;
    }

    public void method_11012() {
        this.disconnect();
        super.method_11012();
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.freq = data.method_10537("freq");
        this.upgrades.readFromNBT(data, "upgrades");
        G.markUsed(this.freq);
        this.color = data.method_10545("color") ? AEColor.valueOf((String)data.method_10558("color")) : AEColor.TRANSPARENT;
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10544("freq", this.freq);
        this.upgrades.writeToNBT(data, "upgrades");
        G.markUsed(this.freq);
        data.method_10582("color", this.color.name());
    }

    public void setFreq(long freq) {
        this.freq = freq;
        this.updateStatus = true;
    }

    public long getNewFreq() {
        return G.genFreq();
    }

    public void disconnect() {
        this.connect.destroy();
    }

    public boolean isConnected() {
        return this.connect.isConnected();
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.DENSE_SMART;
    }

    public void breakOnRemove() {
        this.connect.destroy();
    }

    public long getFrequency() {
        return this.freq;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 card : this.upgrades) {
            drops.add(card);
        }
    }

    public void method_5448() {
        super.method_5448();
        this.upgrades.clear();
    }

    @NotNull
    public AEColor getColor() {
        return this.color;
    }

    public boolean recolourBlock(class_2350 side, AEColor colour, class_1657 who) {
        if (colour == this.color) {
            return false;
        }
        this.color = colour;
        this.saveChanges();
        this.markForUpdate();
        this.getMainNode().setGridColor(this.color);
        return true;
    }
}

