/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.TargetPoint;
import appeng.util.inv.CombinedInternalInventory;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.common.me.CraftingThread;
import com.github.glodblock.extendedae.network.EAENetworkServer;
import com.github.glodblock.extendedae.network.packet.SAssemblerAnimation;
import com.github.glodblock.extendedae.util.FCUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TileExMolecularAssembler
extends AENetworkInvBlockEntity
implements IUpgradeableObject,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final int MAX_THREAD = 8;
    private final IUpgradeInventory upgrades;
    private boolean isPowered = false;
    private final CraftingThread[] threads = new CraftingThread[8];
    private final InternalInventory internalInv;
    private final InternalInventory gridInvExt;
    @Environment(value=EnvType.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public TileExMolecularAssembler(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileExMolecularAssembler.class, TileExMolecularAssembler::new, (class_2248)EAEItemAndBlock.EX_ASSEMBLER), pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.upgrades = UpgradeInventories.forMachine((class_1935)EAEItemAndBlock.EX_ASSEMBLER, (int)this.getUpgradeSlots(), () -> ((TileExMolecularAssembler)this).saveChanges());
        ArrayList<InternalInventory> invs = new ArrayList<InternalInventory>();
        ArrayList<InternalInventory> invs2 = new ArrayList<InternalInventory>();
        for (int x = 0; x < 8; ++x) {
            this.threads[x] = new CraftingThread(this);
            invs.add(this.threads[x].getInternalInventory());
            invs2.add(this.threads[x].getExposedInventoryForSide());
        }
        this.internalInv = new CombinedInternalInventory(invs.toArray(new InternalInventory[0]));
        this.gridInvExt = new CombinedInternalInventory(invs2.toArray(new InternalInventory[0]));
    }

    public int getUpgradeSlots() {
        return 5;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        class_2561 name = this.method_16914() ? this.method_5797() : EAEItemAndBlock.EX_ASSEMBLER.method_8389().method_7848();
        AEItemKey icon = AEItemKey.of((class_1935)EAEItemAndBlock.EX_ASSEMBLER);
        int accelerationCards = this.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD);
        List<Object> tooltip = accelerationCards == 0 ? List.of() : List.of(GuiText.CompatibleUpgrade.text(new Object[]{Tooltips.of((class_2561)AEItems.SPEED_CARD.method_8389().method_7848()), Tooltips.ofUnformattedNumber((long)accelerationCards)}));
        return new PatternContainerGroup(icon, name, tooltip);
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, class_2350 ejectionDirection) {
        for (CraftingThread thread : this.threads) {
            if (!thread.acceptJob(patternDetails, inputs, ejectionDirection)) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }

    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        for (int x = 0; x < 8; ++x) {
            class_2487 tag = this.threads[x].writeNBT();
            data.method_10566("#ct" + x, (class_2520)tag);
        }
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        for (int x = 0; x < 8; ++x) {
            if (!data.method_10545("#ct" + x)) continue;
            this.threads[x].readNBT(data.method_10562("#ct" + x));
        }
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        if (id.equals((Object)MolecularAssemblerBlockEntity.INV_MAIN)) {
            return this.internalInv;
        }
        return super.getSubInventory(id);
    }

    public InternalInventory getCraftInventory(int index) {
        return this.threads[index].getInternalInventory();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread t : this.threads) {
            t.recalculatePlan();
            t.updateSleepiness();
            isAwake |= t.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation rate = TickRateModulation.SLEEP;
        class_1799 firstJob = class_1799.field_8037;
        int cards = this.upgrades.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD);
        for (CraftingThread t : this.threads) {
            if (!t.isAwake()) continue;
            TickRateModulation tr = t.tick(cards, ticksSinceLastCall);
            if (tr.ordinal() > rate.ordinal()) {
                rate = tr;
            }
            if (!firstJob.method_7960()) continue;
            firstJob = t.getOutput();
        }
        AEItemKey item = AEItemKey.of((class_1799)firstJob);
        if (item != null) {
            TargetPoint where = new TargetPoint((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 32.0, this.field_11863);
            EAENetworkServer.INSTANCE.sendToAllAround(new SAssemblerAnimation(this.field_11867, 50, (AEKey)item), where);
        }
        return rate;
    }

    public InternalInventory getInternalInventory() {
        return this.internalInv;
    }

    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        return this.gridInvExt;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        for (CraftingThread t : this.threads) {
            if (inv != t.getInternalInventory()) continue;
            t.recalculatePlan();
            break;
        }
    }

    public int getCraftingProgress(int index) {
        return this.threads[index].getCraftingProgress();
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public void method_5448() {
        super.method_5448();
        this.upgrades.clear();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            boolean newState = false;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                boolean bl = newState = this.getMainNode().isPowered() && grid.getEnergyService().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
            }
            if (newState != this.isPowered) {
                this.isPowered = newState;
                this.markForUpdate();
            }
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public IMolecularAssemblerSupportedPattern getCurrentPattern(int index) {
        return this.threads[index].getCurrentPattern();
    }

    @Environment(value=EnvType.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }
}

