/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import com.github.glodblock.extendedae.api.IPage;
import com.github.glodblock.extendedae.container.ContainerExInterface;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PartExInterface
extends AEBasePart
implements InterfaceLogicHost,
IPage {
    public static List<class_2960> MODELS = Arrays.asList(new class_2960("extendedae", "part/ex_interface"), new class_2960("ae2", "part/interface_on"), new class_2960("ae2", "part/interface_off"), new class_2960("ae2", "part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(3)});
    private static final IGridNodeListener<PartExInterface> NODE_LISTENER = new AEBasePart.NodeListener<PartExInterface>(){

        public void onGridChanged(PartExInterface nodeOwner, IGridNode node) {
            super.onGridChanged((Object)nodeOwner, node);
            nodeOwner.getInterfaceLogic().gridChanged();
        }
    };
    private final InterfaceLogic logic;
    private int page = 0;

    public PartExInterface(IPartItem<?> partItem) {
        super(partItem);
        this.logic = new InterfaceLogic(this.getMainNode(), (InterfaceLogicHost)this, partItem.method_8389(), 36);
    }

    public void openMenu(class_1657 player, MenuLocator locator) {
        MenuOpener.open(ContainerExInterface.TYPE, (class_1657)player, (MenuLocator)locator);
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExInterface.TYPE, (class_1657)player, (MenuLocator)subMenu.getLocator());
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)this, NODE_LISTENER);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.logic.notifyNeighbors();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.logic.readFromNBT(data);
    }

    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.logic.writeToNBT(data);
    }

    public void addAdditionalDrops(List<class_1799> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        this.logic.addDrops(drops);
    }

    public void method_5448() {
        super.method_5448();
        this.logic.clearContent();
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public IConfigManager getConfigManager() {
        return this.logic.getConfigManager();
    }

    public boolean onPartActivate(class_1657 p, class_1268 hand, class_243 pos) {
        if (!p.method_5770().method_8608()) {
            this.openMenu(p, MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public InterfaceLogic getInterfaceLogic() {
        return this.logic;
    }

    public int getPriority() {
        return this.logic.getPriority();
    }

    public void setPriority(int newValue) {
        this.logic.setPriority(newValue);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)UPGRADES)) {
            return this.logic.getUpgrades();
        }
        return super.getSubInventory(id);
    }

    public class_1799 getMainMenuIcon() {
        return new class_1799((class_1935)this.getPartItem());
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

