/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.storage.AEKeyFilter;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import com.github.glodblock.extendedae.EAE;
import com.github.glodblock.extendedae.container.ContainerActiveFormationPlane;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class PartActiveFormationPlane
extends UpgradeablePart
implements IGridTickable,
IPriorityHost,
IConfigInvHost {
    public static final List<class_2960> MODELS = List.of(EAE.id("part/active_formation_plane"), EAE.id("part/active_formation_plane_on"));
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new class_2960[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_OFF});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new class_2960[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_ON});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new class_2960[]{MODELS.get(1), PlaneModels.MODEL_CHASSIS_HAS_CHANNEL});
    private boolean wasOnline = false;
    private int priority = 0;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper((AEBasePart)this);
    private final ConfigInventory config;
    @Nullable
    private PlacementStrategy placementStrategies;

    public PartActiveFormationPlane(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
        this.config = ConfigInventory.configTypes((AEKeyFilter)StackWorldBehaviors.hasPlacementStrategy(), (int)63, null);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, (Enum)YesNo.YES);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    }

    protected final PlacementStrategy getPlacementStrategies() {
        if (this.placementStrategies == null) {
            IGridNode node = this.getMainNode().getNode();
            if (node == null) {
                return PlacementStrategy.noop();
            }
            class_2586 self = this.getHost().getBlockEntity();
            class_2338 pos = self.method_11016().method_10093(this.getSide());
            class_2350 side = this.getSide().method_10153();
            UUID owningPlayerId = this.getMainNode().getNode().getOwningPlayerProfileId();
            this.placementStrategies = StackWorldBehaviors.createPlacementStrategies((class_3218)((class_3218)self.method_10997()), (class_2338)pos, (class_2350)side, (class_2586)self, (UUID)owningPlayerId);
        }
        return this.placementStrategies;
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            if (!this.isClientSide()) {
                this.getPlacementStrategies().clearBlocked();
            }
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    protected long placeInWorld(AEKey what, long amount) {
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        return this.getPlacementStrategies().placeInWorld(what, amount, Actionable.MODULATE, placeBlock != YesNo.YES);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.priority = data.method_10550("priority");
        this.config.readFromChildTag(data, "config");
    }

    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10569("priority", this.getPriority());
        this.config.writeToChildTag(data, "config");
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public class_1799 getMainMenuIcon() {
        return new class_1799((class_1935)this.getPartItem());
    }

    private void openConfigMenu(class_1657 player) {
        MenuOpener.open(this.getMenuType(), (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    protected class_3917<?> getMenuType() {
        return ContainerActiveFormationPlane.TYPE;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.getMin(), TickRates.ExportBus.getMax(), this.isSleeping(), true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        if (!this.canWork()) {
            return TickRateModulation.IDLE;
        }
        boolean hasDoneWork = this.doWork(node.getGrid());
        return hasDoneWork ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    protected final boolean canWork() {
        if (!this.getMainNode().isActive()) {
            return false;
        }
        class_2586 self = this.getHost().getBlockEntity();
        class_2338 targetPos = self.method_11016().method_10093(this.getSide());
        if (self.method_10997() == null) {
            return false;
        }
        if (this.getConfigManager().getSetting(Settings.PLACE_BLOCK) == YesNo.YES) {
            class_2680 block = self.method_10997().method_8320(targetPos);
            return block.method_45474();
        }
        return Platform.areBlockEntitiesTicking((class_1937)self.method_10997(), (class_2338)targetPos);
    }

    protected int availableSlots() {
        return Math.min(18 + this.getInstalledUpgrades((class_1935)AEItems.CAPACITY_CARD) * 9, this.getConfig().size());
    }

    protected boolean doWork(IGrid grid) {
        IStorageService storageService = grid.getStorageService();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        for (int x = 0; x < this.availableSlots(); ++x) {
            AEKey what = this.getConfig().getKey(x);
            if (what == null) continue;
            if (this.isUpgradedWith((class_1935)AEItems.FUZZY_CARD)) {
                for (Object2LongMap.Entry fuzzyWhat : ImmutableList.copyOf((Collection)storageService.getCachedInventory().findFuzzy(what, fzMode))) {
                    if (!this.isSuccess(storageService, (AEKey)fuzzyWhat.getKey())) continue;
                    return true;
                }
                continue;
            }
            if (!this.isSuccess(storageService, what)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuccess(IStorageService storageService, AEKey what) {
        long toExt = storageService.getInventory().extract(what, (long)what.getAmountPerUnit(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
        if (toExt > 0L) {
            long res = this.placeInWorld(what, toExt);
            long differ = toExt - res;
            if (differ > 0L) {
                storageService.getInventory().insert(what, differ, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
            }
            return res > 0L;
        }
        return false;
    }

    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public Object getRenderAttachmentData() {
        return this.getConnections();
    }
}

