/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.me;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.AELog;
import appeng.crafting.CraftingEvent;
import appeng.menu.AutoCraftingMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingThread {
    @NotNull
    private final AENetworkInvBlockEntity host;
    private final AppEngInternalInventory gridInv;
    private final InternalInventory gridInvExt;
    private final class_8566 craftingInv;
    private class_2350 pushDirection = null;
    private class_1799 myPattern = class_1799.field_8037;
    private IMolecularAssemblerSupportedPattern myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    private class_1799 output = class_1799.field_8037;

    public CraftingThread(@NotNull AENetworkInvBlockEntity host) {
        this.host = host;
        this.gridInv = new AppEngInternalInventory((InternalInventoryHost)this.host, 10, 1);
        this.gridInvExt = new FilteredInternalInventory((InternalInventory)this.gridInv, (IAEItemFilter)new CraftingGridFilter());
        this.craftingInv = new class_1715((class_1703)new AutoCraftingMenu(), 3, 3);
    }

    public boolean isAwake() {
        return this.isAwake;
    }

    public boolean acceptJob(IPatternDetails patternDetails, KeyCounter[] table, class_2350 where) {
        if (this.myPattern.method_7960() && this.gridInv.isEmpty() && patternDetails instanceof IMolecularAssemblerSupportedPattern) {
            IMolecularAssemblerSupportedPattern pattern = (IMolecularAssemblerSupportedPattern)patternDetails;
            this.forcePlan = true;
            this.myPlan = pattern;
            this.pushDirection = where;
            this.fillGrid(table, pattern);
            this.updateSleepiness();
            this.saveChanges();
            return true;
        }
        return false;
    }

    public class_2487 writeNBT() {
        class_2487 data = new class_2487();
        if (this.forcePlan) {
            class_1799 pattern;
            class_1799 class_17992 = pattern = this.myPlan != null ? this.myPlan.getDefinition().toStack() : this.myPattern;
            if (!pattern.method_7960()) {
                class_2487 compound = new class_2487();
                pattern.method_7953(compound);
                data.method_10566("myPlan", (class_2520)compound);
                data.method_10569("pushDirection", this.pushDirection.ordinal());
            }
        }
        return data;
    }

    public void readNBT(class_2487 data) {
        class_1799 pattern;
        this.forcePlan = false;
        this.myPattern = class_1799.field_8037;
        this.myPlan = null;
        if (data.method_10545("myPlan") && !(pattern = class_1799.method_7915((class_2487)data.method_10562("myPlan"))).method_7960()) {
            this.forcePlan = true;
            this.myPattern = pattern;
            this.pushDirection = class_2350.values()[data.method_10550("pushDirection")];
        }
        this.recalculatePlan();
    }

    public InternalInventory getInternalInventory() {
        return this.gridInv;
    }

    public InternalInventory getExposedInventoryForSide() {
        return this.gridInvExt;
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    public TickRateModulation tick(int cards, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).method_7960()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).method_7960()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        switch (cards) {
            case 0: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 1.0);
                break;
            }
            case 1: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 26, 1.3);
                break;
            }
            case 2: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 34, 1.7);
                break;
            }
            case 3: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 40, 2.0);
                break;
            }
            case 4: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 2.5);
                break;
            }
            case 5: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 100, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                this.craftingInv.method_5447(x, this.gridInv.getStackInSlot(x));
            }
            this.progress = 0.0;
            this.output = this.myPlan.assemble((class_1263)this.craftingInv, this.host.method_10997());
            if (!this.output.method_7960()) {
                CraftingEvent.fireAutoCraftingEvent((class_1937)this.host.method_10997(), (IPatternDetails)this.myPlan, (class_1799)this.output, (class_1263)this.craftingInv);
                class_2371 craftingRemainders = this.myPlan.getRemainingItems(this.craftingInv);
                this.pushOut(this.output.method_7972());
                for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
                    this.gridInv.setItemDirect(x, (class_1799)craftingRemainders.get(x));
                }
                this.forcePlan = false;
                this.myPlan = null;
                this.pushDirection = null;
                this.ejectHeldItems();
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    public void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            if (this.host.method_10997() != null && this.myPlan == null) {
                IPatternDetails iPatternDetails;
                if (!this.myPattern.method_7960() && (iPatternDetails = PatternDetailsHelper.decodePattern((class_1799)this.myPattern, (class_1937)this.host.method_10997(), (boolean)false)) instanceof IMolecularAssemblerSupportedPattern) {
                    IMolecularAssemblerSupportedPattern supportedPlan;
                    this.myPlan = supportedPlan = (IMolecularAssemblerSupportedPattern)iPatternDetails;
                }
                this.myPattern = class_1799.field_8037;
                if (this.myPlan == null) {
                    AELog.warn((String)"Unable to restore auto-crafting pattern after load: %s", (Object[])new Object[]{this.myPattern.method_7969()});
                    this.forcePlan = false;
                }
            }
            return;
        }
        this.progress = 0.0;
        this.myPlan = null;
        this.myPattern = class_1799.field_8037;
        this.pushDirection = null;
        this.updateSleepiness();
    }

    @Nullable
    public IMolecularAssemblerSupportedPattern getCurrentPattern() {
        if (this.host.isClientSide()) {
            return null;
        }
        return this.myPlan;
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        IGrid grid = this.host.getMainNode().getGrid();
        if (grid != null) {
            return (int)(grid.getEnergyService().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        return 0;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).method_7960()) {
            for (int x = 0; x < 9; ++x) {
                class_1799 is = this.gridInv.getStackInSlot(x);
                if (is.method_7960() || this.myPlan != null && this.myPlan.isItemValid(x, AEItemKey.of((class_1799)is), this.host.method_10997())) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, class_1799.field_8037);
                this.saveChanges();
                return;
            }
        }
    }

    private void pushOut(class_1799 output) {
        if (this.pushDirection == null) {
            for (class_2350 d : class_2350.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output.method_7960() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private void saveChanges() {
        this.host.saveChanges();
    }

    private class_1799 pushTo(class_1799 output, class_2350 d) {
        int newSize;
        if (output.method_7960()) {
            return output;
        }
        class_2586 te = this.host.method_10997().method_8321(this.host.method_11016().method_10093(d));
        if (te == null) {
            return output;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal((class_2586)te, (class_2350)d.method_10153());
        if (adaptor == null) {
            return output;
        }
        int size = output.method_7947();
        int n = newSize = (output = adaptor.addItems(output)).method_7960() ? 0 : output.method_7947();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    private void fillGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern adapter) {
        adapter.fillCraftingGrid(table, (arg_0, arg_1) -> ((AppEngInternalInventory)this.gridInv).setItemDirect(arg_0, arg_1));
        for (KeyCounter list : table) {
            list.removeZeros();
            if (list.isEmpty()) continue;
            throw new RuntimeException("Could not fill grid with some items, including " + list.iterator().next());
        }
    }

    public void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            this.host.getMainNode().ifPresent((grid, node) -> {
                if (this.isAwake) {
                    grid.getTickManager().wakeDevice(node);
                } else {
                    grid.getTickManager().sleepDevice(node);
                }
            });
        }
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.method_5439(); ++x) {
            this.craftingInv.method_5447(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.assemble((class_1263)this.craftingInv, this.host.method_10997()).method_7960();
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).method_7960();
    }

    public class_1799 getOutput() {
        return this.output;
    }

    private static class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 9;
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return false;
        }
    }
}

